/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_MSA_EDITOR_TASKS_H_
#define _GB2_MSA_EDITOR_TASKS_H_

#include <core_api/GObjectReference.h>
#include <util_tasks/ObjectViewTasks.h>

namespace GB2 {

class MAlignmentObject;
class UnloadedObject;
class MSAEditor;

class OpenMSAEditorTask : public ObjectViewTask {
    Q_OBJECT
public:
	OpenMSAEditorTask(MAlignmentObject* obj);
    OpenMSAEditorTask(UnloadedObject* obj);
	OpenMSAEditorTask(Document* doc);

	virtual void open();

private:
	QPointer<MAlignmentObject>  msaObject;
    GObjectReference            unloadedReference;
};

class OpenSavedMSAEditorTask : public ObjectViewTask {
    Q_OBJECT
public:
	OpenSavedMSAEditorTask(const QString& viewName, const QVariantMap& stateData);
	virtual void open();
	
	static void updateRanges(const QVariantMap& stateData, MSAEditor* ctx);
	static void addAnnotations(const QVariantMap& stateData, MSAEditor* ctx);
};


class UpdateMSAEditorTask : public ObjectViewTask {
public:
	UpdateMSAEditorTask(GObjectView* v, const QString& stateName, const QVariantMap& stateData);

	virtual void update();
};


} // namespace

#endif
