/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_SMITH_WATERMAN_DIALOG_H_
#define _GB2_SMITH_WATERMAN_DIALOG_H_

#include <ui/ui_SmithWatermanDialogBase.h>

#include <QDialog>
#include <QCloseEvent>

#include <core_api/core_api.h>
#include <util_smith_waterman/SmithWatermanSettings.h>
#include <util_smith_waterman/SmithWatermanTaskFactory.h>

#include <core_api/SubstMatrixRegistry.h>
#include <core_api/SWResultFilterRegistry.h>
#include <core_api/SmithWatermanTaskFactoryRegistry.h>

namespace GB2 {

class ADVSequenceObjectContext;
class CreateAnnotationWidgetController;

#define DEF_PERCENT_OF_SCORE    90
#define DEF_GAP_OPEN_SCORE      (-10.0f)
#define DEF_GAP_EXTD_SCORE      (-1.0f)

enum SmithWatermanRangeType {
    SmithWatermanRangeType_noRange,
    SmithWatermanRangeType_wholeSequence,
    SmithWatermanRangeType_selectedRange,
    SmithWatermanRangeType_customRange
};

enum SmithWatermanSearchType {
    SmithWatermanSearchType_noSearch,
    SmithWatermanSearchType_inSequence,
    SmithWatermanSearchType_inTranslation
};

struct SWDialogConfig {
    SWDialogConfig() {
        ptrn = QByteArray();
        algVersion = QString("");
        scoringMatrix = QString("");
        
        gm.scoreGapOpen = DEF_GAP_OPEN_SCORE;
        gm.scoreGapExtd = DEF_GAP_EXTD_SCORE;

        resultFilter = QString("");

        minScoreInPercent = DEF_PERCENT_OF_SCORE;

        searchType  = SmithWatermanSearchType_noSearch;
        strand      = SmithWatermanStrand_NoStrand;
        rangeType   = SmithWatermanRangeType_noRange;
    }
    QByteArray ptrn;

    QString algVersion;
    QString scoringMatrix;
    GapModel gm;
    QString resultFilter;

    int minScoreInPercent;      // c {0, 1, ..., 100}

    SmithWatermanSearchType searchType;                
    SmithWatermanStrand     strand;                 
    SmithWatermanRangeType  rangeType;
};

class GB2_COREAPI_EXPORT SmithWatermanDialog: public QDialog, public Ui::SmithWatermanDialogBase {
    Q_OBJECT
public:
    SmithWatermanDialog(QWidget* p, 
                        ADVSequenceObjectContext* ctx,
                        SWDialogConfig* dialogConfig);

private slots:
    void sl_bttnViewMatrix();

    void sl_bttnRun();
    void sl_spinRangeStartChanged(int val);
    void sl_spinRangeEndChanged(int val);
    void sl_translationToggled(bool toggled);

    void sl_wholeSequenceToggled(bool toggled);
    void sl_selectedRangeToggled(bool toggled);
    void sl_customRangeToggled(bool toggled);
private:
    void clearAll();
	void loadDialogConfig();
    void saveDialogConfig();
    bool readParameters();

    bool readPattern(DNATranslation* aminoTT);
    bool readRegion();
    bool readRealization();
    bool readSubstMatrix();
    bool readResultFilter();
    bool readGapModel();

    void setParameters();
    void connectGUI();
    void addAnnotationWidget();

    SubstMatrixRegistry* substMatrixRegistry;
    SWResultFilterRegistry* swResultFilterRegistry;
    SmithWatermanTaskFactoryRegistry* swTaskFactoryRegistry;
	
    SWDialogConfig* dialogConfig;
    SmithWatermanSettings config;
    SmithWatermanTaskFactory* realization;

    ADVSequenceObjectContext* ctxSeq;
    CreateAnnotationWidgetController* ac;
};

} // namespace

#endif

