/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "SmithWatermanUtil.h"

namespace GB2 {

float SmithWatermanUtil::calcScoreItSelf(const SubstMatrix* pSm,
                                         const char* pattern, 
                                         int patternLen) {
    float score = 0.0F;
	for (int i = 0; i < patternLen; i++) {
		score += pSm->getScore(pattern[i], pattern[i]);
	}
	return score;
}

int SmithWatermanUtil::calcWindowLen(bool transl,
                                     int sequenceLen,
                                     int patternLen,
                                     float scoreItSelf,
						             float thresholdScore,
						             float scoreGapOpen,
						             float scoreGapExtd) {
	int tail = (thresholdScore - scoreItSelf + scoreGapOpen) / scoreGapExtd;
	tail = qMax(tail, 0);
	int windowLen = qMin(patternLen + tail, sequenceLen);
    if (transl) {
        windowLen *= 3;
    }
	return windowLen;
}

float SmithWatermanUtil::calcScoreThreshold(float percent, 
                                            float scoreItSelf) {
	if (percent < 0 || 100 < percent) {
		percent = 100;
	}
	float factor = (percent / 100.0F);
	return factor * scoreItSelf;
}

int SmithWatermanUtil::calcOverlapSize(bool transl,
                                       int windowLen,
                                       float scoreItSelf,
                                       float scoreGapOpen, 
                                       float scoreGapExtd) {
	int dependSize = (scoreGapOpen - scoreItSelf) / scoreGapExtd;
	if (transl) {
        dependSize *= 3;
    }
    int overapSize = qMax(windowLen, dependSize);
   	return (overapSize);
}

} // namespace
