/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_DATATYPESET_H_
#define _GB2_DATATYPESET_H_

#include <workflow/Datatype.h>

namespace GB2 {

class WCOREAPI_EXPORT DataTypeSet : public DataType {
public:
    DataTypeSet(const Descriptor& d, const QMap<Descriptor, DataTypePtr>& m) : DataType(d), map(m) {};
    
    virtual DataType::Kind kind() const {return DataType::Map;}
    virtual DataTypePtr getElement(const Descriptor& d) const {return map.value(d);}
    virtual QList<Descriptor> getElements() const {return map.uniqueKeys();}

    virtual QMap<Descriptor, DataTypePtr> getElementsMap() const {return map;}

    //TODO ???
    //virtual bool equals(DataTypePtr t) const {return t == this;} 
    //bool containsSubset(const DataTypeSet& sub) const;
    //DataTypeSet remap(const QMap<QString,QString>& m) const;
    
protected:
    QMap<Descriptor, DataTypePtr> map;
};

class WCOREAPI_EXPORT ListDataType : public DataType {
public:
    ListDataType(const Descriptor& d, DataTypePtr el) : DataType(d), el(el) {};

    virtual DataType::Kind kind() const {return DataType::List;}
    virtual DataTypePtr getElement(const Descriptor& idd=Descriptor(QString())) const { Q_UNUSED(idd); return el;}

    //TODO ???
    //virtual bool equals(DataTypePtr t) const {return t == this;} 

protected:
    DataTypePtr el;
};

} //namespace
#endif
