/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_ANNOTATOR_WORKER_H_
#define _GB2_ANNOTATOR_WORKER_H_

#include <workflow_library/LocalDomain.h>
#include <workflow_support/WorkflowUtils.h>
#include "CollocationsSearchAlgorithm.h"

namespace GB2 {

namespace LocalWorkflow {

class CollocationPrompter;
typedef PrompterBase<CollocationPrompter> CollocationPrompterBase;

class CollocationPrompter : public CollocationPrompterBase {
    Q_OBJECT
public:
    CollocationPrompter(Actor* p = 0) : CollocationPrompterBase(p) {}
    virtual ~CollocationPrompter() {}
protected:
    QString composeRichDoc();
};

class CollocationWorker : public BaseWorker {
    Q_OBJECT
public:
    CollocationWorker(Actor* a) : BaseWorker(a), input(NULL), output(NULL) {}
    virtual ~CollocationWorker() {}
    virtual void init() ;
    virtual bool isReady();
    virtual Task* tick() ;
    virtual bool isDone() ;
    virtual void cleanup() {}
private slots:
    void sl_taskFinished();

protected:
    CommunicationChannel *input, *output;
    QString resultName;
    QSet<QString> names;
    CollocationsAlgorithmSettings cfg;
}; 

class CollocationWorkerFactory : public DomainFactory {
public:
    static const QString ACTOR_ID;
    static void init();
    CollocationWorkerFactory() : DomainFactory(ACTOR_ID) {}
    virtual ~CollocationWorkerFactory() {}
    virtual Worker* createWorker(Actor* a) {return new CollocationWorker(a);}
};

}//Workflow namespace
}//GB2 namespace

#endif
