/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_GL_FRAME_MANAGER_H_
#define _GB2_GL_FRAME_MANAGER_H_

#include <QtOpenGL/QGLWidget>
#include <QtCore/QVariantList>

namespace GB2 { 

class Vector3D;

class Matrix4x4 {
public:
    float m[16];
    Matrix4x4();
    void loadIdentity();
    float* getData() { return m; }
    float& operator [] (unsigned int i);
    Matrix4x4& operator= (const Matrix4x4& m);
    void load(QVariantList values);
    QVariantList store();

};

/*!
* @brief Class for OpenGL 3d scene manipulation
*/
class GLFrame {
    static const GLfloat DEFAULT_ZOOM;
    QGLWidget* glWidget;
    GLfloat zoomFactor;
    Matrix4x4 rotMatrix;
    bool synchLock;
    float cameraClipNear, cameraClipFar;
public:
    GLFrame(QGLWidget* widget, float cameraNear, float cameraFar);
    void setState(const QVariantMap& state);
    void writeStateToMap(QVariantMap& states);
    QGLWidget* getGLWidget() { return glWidget; }
    void makeCurrent() { glWidget->makeCurrent(); }
    void updateViewPort(int width, int height);
    void updateViewPort();
    void updateGL() { glWidget->updateGL(); }
    GLfloat getZoomFactor() { return zoomFactor; }
    float* getRotationMatrix() { return rotMatrix.getData(); }
    void rotateCamera(const Vector3D& rotAxis, float rotAngle);
    void performZoom(float delta);
    
};

class GLFrameManager {
    QMap<QGLWidget*, GLFrame*> widgetFrameMap;
    bool syncLock;

public:
    GLFrameManager() : syncLock(false) {}
    ~GLFrameManager();
    bool getSyncLock() { return syncLock; }
    void setSyncLock(bool lockOn, QGLWidget* syncWidget);
    void addGLFrame(GLFrame* frame);
    GLFrame* getGLWidgetFrame(QGLWidget* widget);
    void removeGLWidgetFrame(QGLWidget* widget);
    QList<GLFrame*> getGLFrames();
    QList<GLFrame*> getActiveGLFrameList(GLFrame* currentFrame, bool syncModeOn);

};






} // namespace


#endif // _GB2_GL_FRAME_MANAGER_H_


