/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_REMOTE_REQUEST_PLUGIN_H_
#define _GB2_REMOTE_REQUEST_PLUGIN_H_

#include <core_api/PluginModel.h>
#include <core_api/ObjectViewModel.h>
#include <core_api/ScriptRegistry.h>
#include <core_api/AppContext.h>

namespace GB2 {

class RemoteRequestViewContext;
class XMLTestFactory;

enum SendSelectionStrand
{
    SendSelectionStrand_Both,
    SendSelectionStrand_Direct,
    SendSelectionStrand_Complement
};

enum SendSelectionAlphabet
{
    SendSelectionAlphabet_Any,
    SendSelectionAlphabet_Nucleo,
    SendSelectionAlphabet_Amino
};


class RemoteRequestPlugin : public Plugin  {
    Q_OBJECT
public:
    RemoteRequestPlugin();
private:
    RemoteRequestViewContext * ctx;
};

class RemoteRequestViewContext : public GObjectViewWindowContext {
    Q_OBJECT
public:
    RemoteRequestViewContext(QObject * p);
protected:
    virtual void initViewContext( GObjectView* view );
private slots:
    void sl_showDialog();
};

class RemoteRequestPluginTests {
public:
    static QList<XMLTestFactory*> createTestFactories();
};

} //namespace

#endif
