/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_BITS_TABLE_H_
#define _GB2_BITS_TABLE_H_

#include <core_api/DNAAlphabet.h>

namespace GB2 {

class BitsTable  {
public:
    quint32 NUCL_BITS[256];
    const static quint32 NUCL_BITS_SIZE;

    quint32 PROTEIN_BITS[256];
    const static quint32 PROTEIN_BITS_SIZE;

    quint32 RAW_BITS[256];
    const static quint32 RAW_BITS_SIZE;
    
    BitsTable();
    virtual ~BitsTable(){}

    quint32 getBitMaskCharBitsNum(DNAAlphabetType alType) const;
    const quint32* getBitMaskCharBits(DNAAlphabetType alType) const;

};

} //namespace

#endif
