/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_SW_ALGORITHM_PLUGIN_H_
#define _GB2_SW_ALGORITHM_PLUGIN_H_

#include <core_api/PluginModel.h>
#include <core_api/ObjectViewModel.h>

#include <util_smith_waterman/SmithWatermanDialog.h>

namespace GB2 {

class XMLTestFactory;
class SWAlgorithmADVContext;

class SWAlgorithmPlugin : public Plugin {
    Q_OBJECT
public:
    SWAlgorithmPlugin();

public slots:
        void regDependedIMPLFromOtherPlugins();

private:
    QList<XMLTestFactory*>  fs;
    SWAlgorithmADVContext * ctxADV;
};


class SWAlgorithmTests {
public:
    static QList<XMLTestFactory*> createTestFactories();
};

class SWAlgorithmADVContext: public GObjectViewWindowContext {
    Q_OBJECT
public:
    SWAlgorithmADVContext(QObject* p);

    protected slots:
    void sl_search();
protected:
    virtual void initViewContext(GObjectView* view);
private:
    SWDialogConfig dialogConfig;
};


} //namespace

#endif
