/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_WORKFLOW_SEQ_ACTOR_H_
#define _GB2_WORKFLOW_SEQ_ACTOR_H_

#include <workflow/Attribute.h>
#include <workflow/IntegralBusModel.h>

#include <workflow_support/WorkflowUtils.h>

namespace GB2 {
namespace Workflow {

class GenericMAActorProto : public BusActorPrototype {
public:
    static const QString TYPE;
    GenericMAActorProto();
    virtual bool isAcceptableDrop(const QMimeData*, QVariantMap*) const;
};

class GenericSeqActorProto : public BusActorPrototype {
public:
    enum Mode{
        SPLIT,
        MERGE,
    };

    static const QString MODE_ATTR;
    static const QString GAP_ATTR;
    static const QString ACC_ATTR;
    static const QString TYPE;

    GenericSeqActorProto();
    virtual bool isAcceptableDrop(const QMimeData*, QVariantMap*) const;
};

class SeqReadPrompter;
typedef PrompterBase<SeqReadPrompter> SeqReadPrompterBase;

class SeqReadPrompter : public SeqReadPrompterBase {
    Q_OBJECT
public:
    SeqReadPrompter(Actor* p = 0) : SeqReadPrompterBase(p) {}
protected:
    QString composeRichDoc();
};

}//namespace Workflow
}//namespace GB2
#endif
