/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef __MUSCLE_4_CONTEXT_
#define __MUSCLE_4_CONTEXT_

#ifdef _MSC_VER
#include <process.h>
#include <windows.h>
#include <psapi.h>
#include <io.h>
#else
#include <sys/time.h>
#include <sys/resource.h>
#include <unistd.h>
#include <errno.h>
#include <fcntl.h>
#include <stdlib.h>
#endif


#include <core_api/Task.h>
#include <string>
#include "muscle4/myutils.h"
#include "muscle4/params.h"
#include "muscle4/mx.h"
//#include "seqdb.h"
#include "muscle4/info.h"
#include <set>
#include <vector>
//#include "muscletypes.h"

struct AlgoFwdBwdData;
struct AlgoTransData;
struct ModelAlgoData;
struct ModelOptTransData;
struct ModelOptDefaultHelpData;
struct OptData;

namespace GB2{

class MatrixContainer{
	public: 
		std::list<MxBase *> *m_Matrices;
		MatrixContainer(){
				m_Matrices = 0;
			}
		

};

class Muscle4Context: public QObject{
Q_OBJECT
public:
	Muscle4Context();
	~Muscle4Context();
	std::string opt_input; 
	std::string opt_output;
	std::string opt_model;	
	std::string opt_matrix;	
	std::string opt_subfamfiles;
	std::string opt_outliers;
	std::string opt_addseqs;
	std::string opt_optimize;
	std::string opt_self_aln;
	std::string opt_maf;
	std::string opt_labelregex;
	std::string opt_posregex;
	std::string opt_tree;
	std::string opt_drawtree;
	std::string opt_profile;	
	std::string opt_blockprefix;

	bool opt_svnrevision;	
	bool opt_version;
	bool opt_inversions_only;
	bool opt_self_only;
	bool opt_msa_only;
	bool opt_xlat;
	bool opt_frameshift_only;
	bool opt_prune_only;

	double opt_minsparseprob;
	double opt_mix;
	double opt_minlocalprob;
	double opt_minlocalid;
	double opt_gaplocal;
	double opt_mincolprob;
	double opt_maxmaskpct;
	double opt_prunedev;
	double opt_pruneacc;
	double opt_optimize_f;
	double opt_frameskew;
	double opt_gbpen;

	bool opt_trace;
	bool opt_logmodels;
	bool opt_logparams;
	bool opt_eaweight;
	bool opt_refinecolprobs;
	bool opt_refineacc;
	bool opt_dotplots;
	bool opt_treeaftercons;
	bool opt_dualbest;
	bool opt_mixea;
	bool opt_self;
	bool opt_seqweights;
	bool opt_sumlog;
	bool opt_refinerand2;
	bool opt_refinerand2e;
	bool opt_refinerand3;
	bool opt_refinetree;
	bool opt_refinerandtree;
	bool opt_highprobupper;
	bool opt_inversions;
	bool opt_lowc;
	bool opt_msa;
	bool opt_subfams;
	bool opt_posteriors;
	bool opt_prune;
	bool opt_colprobs;
	bool opt_clustersize;
	bool opt_accweight;
	bool opt_localtree;
	bool opt_logtree;
	bool opt_treeorder;
	bool opt_alllocals;
	bool opt_allframes;
	bool opt_pruneid;
	bool opt_fasttree;
	bool opt_treeregex;
	bool opt_self1;
	bool opt_onepass;
	bool opt_logfirstpasshits;
	bool opt_realignhits;
	bool opt_allblocks;
	bool opt_sw;
	bool opt_findrepmotifs;
	bool opt_mask;

	unsigned opt_cons;
	unsigned opt_refine;
	unsigned opt_smooth;
	unsigned opt_minlocallen;
	unsigned opt_mmband;
	unsigned opt_maxlocalgap;
	unsigned opt_maxlocaldi;
	unsigned opt_arrangeov;
	unsigned opt_rowlen;
	unsigned opt_maxlabel;
	unsigned opt_minreplen;
	unsigned opt_subrefine;
	unsigned opt_refinemix;
	unsigned opt_maxseqlen;
	unsigned opt_framemin;
	unsigned opt_maxbubble;
	unsigned opt_posregexbase;
	
	double opt_SM;
	double opt_SD;
	double opt_SI;
	double opt_SX;
	double opt_SY;	

	std::vector<AlgoFwdBwdData> g_AlgoFwdBwd;
	std::vector<AlgoTransData> g_AlgoTrans;
	std::vector<ModelAlgoData> g_ModelAlgo;
	std::vector<ModelOptTransData> g_ModelOptTrans;
	std::vector<ModelOptDefaultHelpData> g_ModelOptDefaultHelp;
	std::vector<OptData> g_Opt;
	std::set<std::string> g_Algos;
	
	Mx<float> g_SimMxf;

	//bool opt_quiet;
	//bool opt_logopts;
	//bool opt_compilerinfo;
	//bool opt_help;
	//string opt_log;
	
	std::string g_CurrentProgressLine;
	std::vector<string> g_ProgressDesc;
	std::vector<unsigned> g_ProgressIndex;
	std::vector<unsigned> g_ProgressCount;
	
	unsigned g_CurrProgressLineLength;
	unsigned g_LastProgressLineLength;
	unsigned g_CountsInterval;
	time_t g_TimeLastOutputStep;

	std::set<OptInfo> g_Opts;

	char Str[16];
	char Str1[32];

	std::vector<RepeatInfo> g_Repeats;
	std::vector<DupeInfo> g_Dupes;

	std::vector<unsigned> Pos1ToCol;
	std::vector<unsigned> Pos2ToCol;
	std::vector<unsigned> ColToPos1;
	std::vector<unsigned> ColToPos2;
	
	FILE *g_fLog;

	char *g_IOBuffers[256];
	time_t g_StartTime;
	std::vector<std::string> g_Argv;
	double g_PeakMemUseBytes;

	Mx<float> g_DP;
	Mx<char> g_TB;
	
	Mx<float> g_FwdM;
	Mx<char> g_TB1;

	unsigned g_Buffer1Size;
	unsigned g_Buffer2Size;
	uint16 *g_Buffer2;

	float *g_Buffer1;

	std::vector<SeqDB *> g_InternalNodeMSAs;
	std::vector<SparseMx *> *g_SPPs;
	std::vector<float> g_NodeAccs;
	unsigned g_SubfamCounter;
	std::string g_SubFamFilenamePrefix;
	SeqDB *g_Input;
	unsigned g_NodeCounter;
	
	Mx<float> g_FwdM2;
	Mx<char> g_TB2;

	std::vector<InvertInfo> g_InvertInfos;

	std::vector<vector<SeqDB *> > g_MSAs;
	std::vector<std::vector<unsigned> > g_BlockIndexes;
	std::vector<unsigned> g_BlockIndexes1;
	std::vector<unsigned> g_BlockIndexes2;

	unsigned g_BlockIndex;
	unsigned g_ProgressCounter;

	FILE *g_fMAF;
	Tree *g_Tree;
	
	Mx<float> g_MatchMx;

	Mx<float> g_FwdM3; 
	Mx<char> g_TBM3;

	Mx<float> g_FwdD3; 
	Mx<char> g_TBD3;

	Mx<float> g_FwdI3; 
	Mx<char> g_TBI3;

	Mx<float> g_FwdM4;
	Mx<float> g_FwdD4;
	Mx<float> g_FwdI4;

	std::string g_Model;
	
	Mx<float> g_BwdM5;
	Mx<float> g_BwdD5;
	Mx<float> g_BwdI5;
	Mx<float> g_BwdX5;
	Mx<float> g_BwdY5;

    Mx<float> g_BwdM6;
	Mx<float> g_BwdD6;
	Mx<float> g_BwdI6;

	Mx<float> g_FwdM7;
	Mx<float> g_FwdD7;
	Mx<float> g_FwdI7;
	Mx<float> g_FwdX7;
	Mx<float> g_FwdY7;

	byte g_DNAIndexToAA[65];
	
	bool InitDone;
	
	Mx<float> g_DPMemf;

	std::vector<float> *g_Accs;

	unsigned g_MatrixFileCount;

	 int  tagstk[10];             /* subpat tag stack..*/
	 char nfa[1024];		/* automaton..       */
	 int  sta;               	/* status of lastpat */
	 char bittab[16];
	 
	 Mx<float> g_SimMxf2;
	 unsigned g_TreeDepth;

	 std::vector<std::pair<SeqDB *, unsigned> > g_Pairs;

	 Mx<float> g_MatchMx2;
	 
	 char statm[64];
	 int PageSize;

	 unsigned m_MaxNonZeroValuesPerRow;
	 float *m_RowValueBuffer;
	 unsigned *m_ColIndexBuffer;
	 float *m_RowValueBuffer2;
	 unsigned *m_ColIndexBuffer2;
	 unsigned m_TotalFractValuesBytes;
	 unsigned m_TotalColIndexesBytes;
	 unsigned m_TotalStartPosBytes;
	 unsigned m_TotalCellCount;
     unsigned m_TotalRowCount;
	
	 Mx<float> g_SubstMxf;

	 GB2::TaskStateInfo* info;

	 char smx1[16];
	
	 float TransSM;
	 float TransSD;
	 float TransSI;
	 float TransSX;
	 float TransSY;

	 float TransME;
	 float TransDE;
	 float TransIE;
	 float TransXE;
	 float TransYE;

	 float TransMM;
	 float TransDM;
	 float TransIM;
	 float TransXM;
	 float TransYM;

	 float TransMD;
	 float TransMI;
	 float TransMX;
	 float TransMY;

	 float TransDD;
	 float TransII;
	 float TransXX;
	 float TransYY;

	 float TransLMD;
	 float TransLMI;
	 float TransLMX;
	 float TransLMY;

	 float TransLDD;
	 float TransLII;
	 float TransLXX;
	 float TransLYY;

	 float TransRMD;
	 float TransRMI;
	 float TransRMX;
	 float TransRMY;

	 float TransRDD;
	 float TransRII;
	 float TransRXX;
	 float TransRYY;
	
	 std::vector<byte *> leaked_pointers;

	 std::vector<QByteArray* >leaked_arrays;

};


class Muscle4Exception {
public:
    Muscle4Exception();
    Muscle4Exception(const char* str);
    char str[4096];
};

void stopIfCanceled(GB2::TaskStateInfo& info);
}

#endif