/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef  _UMUSCLE4_PLUGIN_H_
#define  _UMUSCLE4_PLUGIN_H_

#include <core_api/PluginModel.h>
#include <core_api/AppContext.h>
#include <core_api/ObjectViewModel.h>

#include <QtGui/QMenu>

namespace GB2 {

class MSAEditor;
class Muscle4MSAEditorContext;
class XMLTestFactory;

class Muscle4Plugin : public Plugin {
    Q_OBJECT
public:
    Muscle4Plugin();
    ~Muscle4Plugin();

private:
    Muscle4MSAEditorContext* ctx;
};


class Muscle4MSAEditorContext: public GObjectViewWindowContext {
    Q_OBJECT
public:
    Muscle4MSAEditorContext(QObject* p);

protected slots:
    void sl_align();
    void sl_alignSequencesToProfile();
    void sl_alignProfileToProfile();

protected:
    virtual void initViewContext(GObjectView* view);
    virtual void buildMenu(GObjectView* v, QMenu* m);
};

class Muscle4Action : public GObjectViewAction {
    Q_OBJECT
public:
    Muscle4Action(QObject* p, GObjectView* v, const QString& text)  : GObjectViewAction(p,v,text) {}
    MSAEditor*  getMSAEditor() const;

private slots:
    void sl_lockedStateChanged();
};

} //namespace

#endif