/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "myutils.h"
#include "seqdb.h"
#include "mx.h"
#include "sparsemx.h"
#include "tree.h"
#include "params.h"
#include "Muscle4TaskLocalStorage.h"
#include "Muscle4Task.h"
#include "Muscle4Adapter.h"
//#include <QObject.h>
#include <core_api/DocumentModel.h>
//#define _CRTDBG_MAP_ALLOC
//#include <crtdbg.h>
//#include <stdlib.h>

float ComputeColProbs(SeqDB &Input, const SeqDB &msa,
  vector<unsigned> &LetterPairCounts, vector<float> &PairProbs,
  vector<float> &ColProbs, float &SumPairProbs, float &SumColProbs);

void LogPosteriorDotPlots(vector<SparseMx *> &MatchPosteriors)
	{
	const unsigned N = SIZE(MatchPosteriors);
	for (unsigned i = 0; i < N; ++i)
		MatchPosteriors[i]->LogSmallDotPlot();
	}

SeqDB &SeqDB::Align(unsigned ConsIters, unsigned RefineIters,
					bool DoSequenceWeighting, const string &SubFamFileNamePrefix)
	{
	GB2::Muscle4Context *ctx = getMuscle4Context();
	stopIfCanceled(*(ctx->info));
	if (ctx->opt_localtree){
		}
	else{
		if (ctx->opt_cons > 0)
			{
			ComputeSPPs(false);
			stopIfCanceled(*(ctx->info));
			ComputeAccAndIdMxs();
			}
		ComputeGuideTree();
		}

	if (DoSequenceWeighting)
		ComputeSeqWeights(m_GuideTree);

	for (unsigned i = 0; i < ConsIters; ++i)
		Cons(i, ConsIters);

	stopIfCanceled(*(ctx->info));
	if (ctx->opt_accweight)
		{
		vector<float> AvgAccs;
		vector<float> FractIds;
		float Acc;
		float FractId;
		ComputeAccsAndIds(AvgAccs, FractIds, Acc, FractId);
		vector<float> NewWeights;

		const unsigned SeqCount = GetSeqCount();
		float SumWeights = 0;
		for (unsigned i = 0; i < SeqCount; ++i)
			{
			float Acc = AvgAccs[i];
			if (Acc < 0.2f)
				Acc = 0.2f;
			float NewWeight = m_Weights[i]/Acc;
			SumWeights += NewWeight;
			NewWeights.push_back(NewWeight);
			}
		for (unsigned i = 0; i < SeqCount; ++i)
			NewWeights[i] /= SumWeights;
		}

	SeqDB &msa = ProgressiveAlign(SubFamFileNamePrefix);
	if (msa.GetSeqCount() <= 2)
		return msa;

	ctx->info->progress = 90;
	for (unsigned i = 0; i < RefineIters; ++i){
		stopIfCanceled(*(ctx->info));
		ctx->info->setStateDesc(tr("Refine"));
		Refine(msa, i, RefineIters);
	}
	if (ctx->opt_treeorder)
		msa.SortByTree(m_GuideTree);
	else
		msa.SortByUser();
	return msa;
	}
