/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "myutils.h"
#include "sumlog.h"
#include "params.h"
#include "mx.h"
#include "seqdb.h"
#include "Muscle4TaskLocalStorage.h"
//#define		m(x)	static Mx<float> g_Bwd##x;
//	m(M)
//	m(D)
//	m(I)
//	m(X)
//	m(Y)
//#undef m
//#define _CRTDBG_MAP_ALLOC
//#include <crtdbg.h>
//#include <stdlib.h>

void BwdFull()
	{
	GB2::Muscle4Context *ctx = getMuscle4Context();
	Mx<float> &Simf = GetSimMxf();

	const unsigned LA = Simf.m_RowCount - 1;
	const unsigned LB = Simf.m_ColCount - 1;

#define		m(x)	ctx->g_Bwd##x.Alloc("Full_Bwd"#x, LA+1, LB+1, Simf.m_SeqDB, Simf.m_IdA, Simf.m_IdB);	 \
					float **Bwd##x = ctx->g_Bwd##x.GetData();
	m(M5)
	m(D5)
	m(I5)
	m(X5)
	m(Y5)
#undef m

	const float * const *SimMx = Simf.GetData();	

// Init origin
	BwdM5[LA][LB] = float (0) /*ME*/;
	BwdD5[LA][LB] = float (0) /*DE*/;
	BwdI5[LA][LB] = float (0) /*IE*/;
	BwdX5[LA][LB] = float (0) /*XE*/;
	BwdY5[LA][LB] = float (0) /*YE*/;
	
// Init zero'th row A
	{
	for (int i = (int) LA; i >= 0; --i)
		{
		BwdM5[i][0] = LOG_ZERO;
		BwdD5[i][0] = LOG_ZERO;
		BwdI5[i][0] = LOG_ZERO;
		BwdX5[i][0] = LOG_ZERO;
		BwdY5[i][0] = LOG_ZERO;
		}
	
	float s = ctx->TransRII;
	float t = ctx->TransRYY;
	for (int i = (int) LA-1; i > 0; --i)
		{
		float s1 = BwdD5[i+1][LB] + ctx->TransRMD;
		float s2 = BwdX5[i+1][LB] + ctx->TransRMX;
		BwdM5[i][LB] = SumLog2(s1, s2);
		
		BwdI5[i][LB] = LOG_ZERO;
		BwdD5[i][LB] = s;
		s += ctx->TransRDD;
		
		BwdY5[i][LB] = LOG_ZERO;
		BwdX5[i][LB] = t;
		t += ctx->TransRXX;
		}
	}
	
// Init zero'th row B
	{
	for (int j = (int) LB; j >= 0; --j)
		{
		BwdM5[0][j] = LOG_ZERO;
		BwdD5[0][j] = LOG_ZERO;
		BwdI5[0][j] = LOG_ZERO;
		BwdX5[0][j] = LOG_ZERO;
		BwdY5[0][j] = LOG_ZERO;
		}
	
	float s = ctx->TransRDD;
	float t = ctx->TransRXX;
	for (int j = (int) LB-1; j > 0; --j)
		{
		float s1 = BwdI5[LA][j+1] + ctx->TransRMI;
		float s2 = BwdY5[LA][j+1] + ctx->TransRMY;
		BwdM5[LA][j] = SumLog2(s1, s2);
		
		BwdD5[LA][j] = LOG_ZERO;
		BwdI5[LA][j] = s;
		s += ctx->TransRDD;
		
		BwdX5[LA][j] = LOG_ZERO;
		BwdY5[LA][j] = t;
		t += ctx->TransRXX;
		}
	}
	
	const float *SimMxRow;
	
// Main loop
	for (int i = (int) LA-1; i > 0; --i)
		{
		SimMxRow = SimMx[i+1];
		for (int j = (int) LB-1; j > 0; --j)
			{
			float Match = SimMxRow[j+1];
			
		// Mx
			{
			float MM = BwdM5[i+1][j+1] + Match;
			float MD = BwdD5[i+1][j] + ctx->TransMD;
			float MI = BwdI5[i][j+1] + ctx->TransMI;
			float MX = BwdX5[i+1][j] + ctx->TransMX;
			float MY = BwdY5[i][j+1] + ctx->TransMY;
			BwdM5[i][j] = SumLog5(MM, MD, MI, MX, MY);
			}
			
		// Dx
			{
			float DM = BwdM5[i+1][j+1] + Match;
			float DD = BwdD5[i+1][j] + ctx->TransDD;
			BwdD5[i][j] = SumLog2(DM, DD);
			}
			
		// Ix
			{
			float IM = BwdM5[i+1][j+1] + Match;
			float II = BwdI5[i][j+1] + ctx->TransII;
			BwdI5[i][j] = SumLog2(IM, II);
			}
			
		// Xx
			{
			float XM = BwdM5[i+1][j+1] + Match;
			float XX = BwdX5[i+1][j] + ctx->TransXX;
			BwdX5[i][j] = SumLog2(XM, XX);
			}
			
		// Yx
			{
			float YM = BwdM5[i+1][j+1] + Match;
			float YY = BwdY5[i][j+1] + ctx->TransYY;
			BwdY5[i][j] = SumLog2(YM, YY);
			}
			}
		}
	}
