/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "myutils.h"
#include "sumlog.h"
#include "params.h"
#include "mx.h"
#include "seqdb.h"
#include "Muscle4TaskLocalStorage.h"
//#define _CRTDBG_MAP_ALLOC
//#include <crtdbg.h>
//#include <stdlib.h>

//#define		m(x)	static Mx<float> g_Bwd##x;
//	m(M)
//	m(D)
//	m(I)
//#undef m

void BwdSWCRF()
	{
	GB2::Muscle4Context *ctx = getMuscle4Context();
	Mx<float> &Simf = GetSimMxf();

	const float * const *SimMx = Simf.GetData();

	const unsigned LA = Simf.m_RowCount - 1;
	const unsigned LB = Simf.m_ColCount - 1;

#define		m(x)	ctx->g_Bwd##x.Alloc("SWCRF_Bwd"#x, LA+1, LB+1, Simf.m_SeqDB, Simf.m_IdA, Simf.m_IdB);	 \
					float **Bwd##x = ctx->g_Bwd##x.GetData();
	m(M6)
	m(D6)
	m(I6)
#undef m

	for (int i = (int) LA; i >= 0; --i)
		{
		BwdM6[i][0] = LOG_ZERO;
		BwdD6[i][0] = LOG_ZERO;
		BwdI6[i][0] = LOG_ZERO;
		}

	for (int j = (int) LB; j >= 0; --j)
		{
		BwdM6[0][j] = LOG_ZERO;
		BwdD6[0][j] = LOG_ZERO;
		BwdI6[0][j] = LOG_ZERO;
		}
	
	for (int i = (int) LA; i > 0; --i)
		{
		BwdM6[i][LB] = 0;
		BwdI6[i][LB] = LOG_ZERO;
		BwdD6[i][LB] = LOG_ZERO;
		}

	for (int j = (int) LB; j > 0; --j)
		{
		BwdM6[LA][j] = 0;
		BwdD6[LA][j] = LOG_ZERO;
		BwdI6[LA][j] = LOG_ZERO;
		}

	BwdM6[LA][LB] = 0;
	BwdD6[LA][LB] = LOG_ZERO;
	BwdI6[LA][LB] = LOG_ZERO;
	
// Main loop
	for (int i = (int) LA-1; i > 0; --i)
		{
		const float *SimMxRow = SimMx[i+1];
		for (int j = (int) LB-1; j > 0; --j)
			{
			float Match = SimMxRow[j+1];
			const float BMM = BwdM6[i+1][j+1] + Match;
		// Mx
			{
			float MM = BMM;
			float MD = BwdD6[i+1][j] + ctx->TransMD;
			float MI = BwdI6[i][j+1] + ctx->TransMI;
			float ME = 0;
			BwdM6[i][j] = SumLog4(MM, MD, MI, ME);
			}
			
		// Dx
			{
			float DM = BMM;
			float DD = BwdD6[i+1][j] + ctx->TransDD;
			BwdD6[i][j] = SumLog2(DM, DD);
			}
			
		// Ix
			{
			float IM = BMM;
			float II = BwdI6[i][j+1] + ctx->TransII;
			BwdI6[i][j] = SumLog2(IM, II);
			}
			}
		}
	}
