/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "myutils.h"
#include "sumlog.h"
#include "params.h"
#include "mx.h"
#include "seqdb.h"
#include "Muscle4TaskLocalStorage.h"
//#define _CRTDBG_MAP_ALLOC
//#include <crtdbg.h>
//#include <stdlib.h>

//#define		m(x)	static Mx<float> g_Fwd##x;
//	m(M)
//	m(D)
//	m(I)
//	m(X)
//	m(Y)
//#undef m

void FwdFull()
	{
	GB2::Muscle4Context* ctx = getMuscle4Context();
	Mx<float> &Simf = GetSimMxf();

	const unsigned LA = Simf.m_RowCount - 1;
	const unsigned LB = Simf.m_ColCount - 1;

#define		m(x)	ctx->g_Fwd##x.Alloc("Full_Fwd"#x, LA+1, LB+1, Simf.m_SeqDB, Simf.m_IdA, Simf.m_IdB);	 \
					float **Fwd##x = ctx->g_Fwd##x.GetData();
	m(M7)
	m(D7)
	m(I7)
	m(X7)
	m(Y7)
#undef m

	const float * const *SimMx = Simf.GetData();
	const float *SimMxRow;
	
	FwdM7[0][0] = float (0);
	FwdD7[0][0] = LOG_ZERO;
	FwdI7[0][0] = LOG_ZERO;
	FwdX7[0][0] = LOG_ZERO;
	FwdY7[0][0] = LOG_ZERO;
	
// Init zero'th row A
	{
	float s = ctx->TransSD;
	float x = ctx->TransSX;
	for (unsigned i = 0; i < LA; ++i)
		{
		if (i > 0)
			{
			s += ctx->TransLDD;
			x += ctx->TransLXX;
			}
		FwdM7[i+1][0] = LOG_ZERO;
		FwdD7[i+1][0] = s;
		FwdX7[i+1][0] = x;
		FwdI7[i+1][0] = LOG_ZERO;
		FwdY7[i+1][0] = LOG_ZERO;
		}
	}
	
// Init zero'th row B
	{
	float s = ctx->TransSI;
	float x = ctx->TransSY;
	for (unsigned j = 0; j < LB; ++j)
		{
		if (j > 0)
			{
			s += ctx->TransLII;
			x += ctx->TransLYY;
			}
		FwdM7[0][j+1] = LOG_ZERO;
		FwdD7[0][j+1] = LOG_ZERO;
		FwdX7[0][j+1] = LOG_ZERO;
		FwdI7[0][j+1] = s;
		FwdY7[0][j+1] = x;
		}
	}
	
// Main loop
	for (unsigned i = 0; i < LA; ++i)
		{
		SimMxRow = SimMx[i+1];
		const bool RightA = (i == LA-1);
		for (unsigned j = 0; j < LB; ++j)
			{
			const bool RightB = (j == LB-1);
			
		// xM
			{
			float Match = SimMxRow[j+1];
			float MM = FwdM7[i][j];
			float DM = FwdD7[i][j];
			float IM = FwdI7[i][j];
			float XM = FwdX7[i][j];
			float YM = FwdY7[i][j];
			FwdM7[i+1][j+1] = SumLog5(MM, DM, IM, XM, YM) + Match;
			}
			
		// xD
			{
			float EdgeMD = (RightB ? ctx->TransRMD : ctx->TransMD);
			float EdgeDD = (RightB ? ctx->TransRDD : ctx->TransDD);
			float MD = FwdM7[i][j+1] + EdgeMD;
			float DD = FwdD7[i][j+1] + EdgeDD;
			FwdD7[i+1][j+1] = SumLog2(MD, DD);
			}
			
		// xI
			{
			float EdgeMI = (RightA ? ctx->TransRMI : ctx->TransMI);
			float EdgeII = (RightA ? ctx->TransRII : ctx->TransII);
			float MI = FwdM7[i+1][j] + EdgeMI;
			float II = FwdI7[i+1][j] + EdgeII;
			FwdI7[i+1][j+1] = SumLog2(MI, II);
			}
			
		// xX
			{
			float EdgeMX = (RightB ? ctx->TransRMX : ctx->TransMX);
			float EdgeXX = (RightB ? ctx->TransRXX : ctx->TransXX);
			float MX = FwdM7[i][j+1] + EdgeMX;
			float XX = FwdX7[i][j+1] + EdgeXX;
			FwdX7[i+1][j+1] = SumLog2(MX, XX);
			}
			
		// xY
			{
			float EdgeMY = (RightA ? ctx->TransRMY : ctx->TransMY);
			float EdgeYY = (RightA ? ctx->TransRYY : ctx->TransYY);
			float MY = FwdM7[i+1][j] + EdgeMY;
			float YY = FwdY7[i+1][j] + EdgeYY;
			FwdY7[i+1][j+1] = SumLog2(MY, YY);
			}
			}
		}
	}
