/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "myutils.h"
#include "seqdb.h"
#include "mx.h"
#include "params.h"
#include "Muscle4TaskLocalStorage.h"

//#define _CRTDBG_MAP_ALLOC
//#include <crtdbg.h>
//#include <stdlib.h>
//static Mx<float> g_SimMxf;

float **GetSimMx(SeqDB &DB, unsigned IdA, unsigned IdB)
	{
	GB2::Muscle4Context *ctx = getMuscle4Context();
	const unsigned LA = DB.GetSeqLength(IdA);
	const unsigned LB = DB.GetSeqLength(IdB);
	if (ctx->g_SimMxf2.m_SeqDB == &DB && ctx->g_SimMxf2.m_IdA == IdA && ctx->g_SimMxf2.m_IdB == IdB)
		return ctx->g_SimMxf2.GetData();

	ctx->g_SimMxf2.Alloc("Sim", LA+1, LB+1, &DB, IdA, IdB);

	float **Sim = ctx->g_SimMxf.GetData();
	float **SubstMx = GetSubstMx();

	const byte *A = DB.GetSeq(IdA);
	const byte *B = DB.GetSeq(IdB);

	for (unsigned i = 0; i <= LA; ++i)
		Sim[i][0] = 0.0f;

	for (unsigned j = 0; j <= LB; ++j)
		Sim[0][j] = 0.0f;

	for (unsigned i = 0; i < LA; ++i)
		{
		byte a = A[i];
		float *SubstRow = SubstMx[a];
		float *SimRow = Sim[i+1];
		for (unsigned j = 0; j < LB; ++j)
			{
			byte b = B[j];
			SimRow[j+1] = SubstRow[b];
			}
		}

	if (IdA == IdB)
		{
		for (unsigned i = 1; i <= LA; ++i)
			Sim[i][i] = 0;
		}

	return Sim;
	}
