/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "NetworkSettingsGUIController.h"

#include <core_api/AppContext.h>
#include <core_api/AppSettings.h>

namespace GB2
{

NetworkSettingsPageState::NetworkSettingsPageState()
: config(*AppContext::getAppSettings()->getNetworkConfiguration())
{
}

NetworkSettingsPageController::NetworkSettingsPageController(QObject* p) 
: AppSettingsGUIPageController(tr("network_settings"), APP_SETTINGS_GUI_NETWORK, p)
{
}


AppSettingsGUIPageState* NetworkSettingsPageController::getSavedState() {
    NetworkSettingsPageState* state = new NetworkSettingsPageState();
    state->config = *AppContext::getAppSettings()->getNetworkConfiguration();
    return state;
}

void NetworkSettingsPageController::saveState(AppSettingsGUIPageState* s) {
    NetworkSettingsPageState* state = qobject_cast<NetworkSettingsPageState*>(s);
    NetworkConfiguration* dst = AppContext::getAppSettings()->getNetworkConfiguration();
    dst->copyFrom(state->config);
}

AppSettingsGUIPageWidget* NetworkSettingsPageController::createWidget(AppSettingsGUIPageState* data) {
    NetworkSettingsPageWidget* r =  new NetworkSettingsPageWidget();
    r->setState(data);
    return r;
}


NetworkSettingsPageWidget::NetworkSettingsPageWidget() {
    setupUi( this );
    connect( httpProxyCheck, SIGNAL(stateChanged(int)), SLOT(sl_HttpChecked(int)) );
    connect( proxyExceptionsCheck, SIGNAL(stateChanged(int)), SLOT(sl_ExceptionsChecked(int)) );
}


void NetworkSettingsPageWidget::sl_HttpChecked( int state ) {
    httpProxyAddrEdit->setEnabled( state == Qt::Checked );
    httpProxyPortEdit->setEnabled( state == Qt::Checked );
    sl_ExceptionsChecked(state);
}

void NetworkSettingsPageWidget::sl_ExceptionsChecked(int) {
    proxyExceptionsEdit->setEnabled(httpProxyCheck->isChecked() && proxyExceptionsCheck->isChecked());
}

void NetworkSettingsPageWidget::setState(AppSettingsGUIPageState* s) {
    NetworkSettingsPageState* state = qobject_cast<NetworkSettingsPageState*>(s);
    const NetworkConfiguration& set = state->config;
    QNetworkProxy cur_proxy = set.getProxy( QNetworkProxy::HttpProxy );
    if( QNetworkProxy::DefaultProxy != cur_proxy.type() ) {
        httpProxyAddrEdit->insert( cur_proxy.hostName() );
        httpProxyPortEdit->setValue( cur_proxy.port() );
        httpProxyCheck->setCheckState( Qt::Checked );
    } 
    if( !set.isProxyUsed(QNetworkProxy::HttpProxy) ){
        httpProxyAddrEdit->setDisabled( true );
        httpProxyPortEdit->setDisabled( true );
        httpProxyCheck->setCheckState( Qt::Unchecked );
    }

    proxyExceptionsEdit->setPlainText( set.getExceptionsList().join("\n") );
    if( set.exceptionsEnabled() ) {
        proxyExceptionsCheck->setCheckState( Qt::Checked );
    } else {
        proxyExceptionsEdit->setDisabled( true );
    }
}

AppSettingsGUIPageState* NetworkSettingsPageWidget::getState(QString& err) const {
    Q_UNUSED(err);
    NetworkSettingsPageState* state = new NetworkSettingsPageState();
    NetworkConfiguration& set = state->config;

    set.addProxy( QNetworkProxy( QNetworkProxy::HttpProxy, httpProxyAddrEdit->text()));

    if( !httpProxyAddrEdit->text().isEmpty() && !httpProxyPortEdit->text().isEmpty() ) {
        set.addProxy( QNetworkProxy( QNetworkProxy::HttpProxy, httpProxyAddrEdit->text(), httpProxyPortEdit->value()));
    }

    set.setExceptionsList( proxyExceptionsEdit->toPlainText().split( "\n", QString::SkipEmptyParts ) );
    set.setProxyUsed( QNetworkProxy::HttpProxy, httpProxyCheck->isChecked() );
    set.setExceptionsEnabled( proxyExceptionsCheck->isChecked() );

    return state;
}

} //namespace
