/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "ProjectViewImpl.h"
#include <core_api/ObjectViewModel.h>

#include <util_ov_textview/SimpleTextObjectView.h>
#include <util_ov_annotated_dna/AnnotatedDNAViewFactory.h>
#include <util_ov_msaedit/MSAEditorFactory.h>
#include <util_ov_indexview/UIndexViewerFactory.h>

namespace GB2 {

void ProjectViewImpl::registerBuiltInObjectViews() {
	GObjectViewFactoryRegistry* reg = AppContext::getObjectViewFactoryRegistry();
	
	GObjectViewFactory* f = new SimpleTextObjectViewFactory();
	reg->registerGObjectViewFactory(f);

	f =  new AnnotatedDNAViewFactory();
	reg->registerGObjectViewFactory(f);

    f = new MSAEditorFactory();
    reg->registerGObjectViewFactory(f);

    f = new UIndexViewerFactory();
    reg->registerGObjectViewFactory( f );
}

void ProjectViewImpl::unregisterBuiltInObjectViews() {
	GObjectViewFactoryRegistry* reg = AppContext::getObjectViewFactoryRegistry();
	
	GObjectViewFactory* f = reg->getFactoryById(SimpleTextObjectViewFactory::ID);
	assert(f!=NULL);
	reg->unregisterGObjectViewFactory(f);
	delete f;

	f = reg->getFactoryById(AnnotatedDNAViewFactory::ID);
	assert(f!=NULL);
	reg->unregisterGObjectViewFactory(f);
	delete f;

    f = reg->getFactoryById(MSAEditorFactory::ID);
    assert(f!=NULL);
    reg->unregisterGObjectViewFactory(f);
    delete f;

    f = reg->getFactoryById( UIndexViewerFactory::ID );
    assert( NULL != f );
    reg->unregisterGObjectViewFactory( f );
    delete f;
}

}//namespace

