/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_SCRIPT_MANAGER_WIDGET_IMPL_H_
#define _GB2_SCRIPT_MANAGER_WIDGET_IMPL_H_

#include <ui/ui_ScriptManagerWidget.h>
#include <core_api/ScriptRegistry.h>


namespace GB2 
{
class Task;
class ScriptManagerWidgetImpl: public QWidget, public Ui::ScriptManagerWidget {
    Q_OBJECT
public:
    ScriptManagerWidgetImpl( QWidget * p, ScriptRegistryService * sr );
private:
    void updateState();
    void updateItem( int idx, Script * scr );

    static const int COL_STATE  = 3;
    static const int COL_URL    = 2;
    static const int COL_TYPE   = 1;
    static const int COL_NAME   = 0;

    ScriptRegistryService * sr;
    QList<Script *> scripts;
    QList<Task *> scheduled_tasks;
private slots:
    void sl_Add();
    void sl_Delete();
    void sl_Reload();
    void sl_scriptReloaded( Task * t );
};

} //namespace

#endif
