##################################################################
# Unipro UGENE - Integrated Bioinformatics Suite
# Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
# All Rights Reserved
# 
#
#     This source code is distributed under the terms of the
#     GNU General Public License. See the files COPYING and LICENSE
#     for details.
##################################################################

include( src/ugene_globals.pri )

TEMPLATE = subdirs debug_and_release
CONFIG += ordered
use_bundled_zlib() {
    SUBDIRS = src/libs_3rdparty/zlib
}
SUBDIRS += src/libs_3rdparty/qtbindings_core \
          src/libs_3rdparty/qtbindings_gui \
          src/libs_3rdparty/qtbindings_xml \
          src/core \
          src/ugene \
          src/congene \
          src/plugins_3rdparty/ball \
          src/plugins_3rdparty/sitecon \
          src/plugins_3rdparty/umuscle \
          src/plugins_3rdparty/hmm2 \
          src/plugins_3rdparty/script_debuger \
          src/plugins_3rdparty/gor4 \
          src/plugins_3rdparty/psipred \
          src/plugins/biostruct3d_view \
          src/plugins/chroma_view \
          src/plugins/annotator \
          src/plugins/dna_export \
          src/plugins/dna_stat \
          src/plugins/dna_graphpack \
          src/plugins/orf_marker \
          src/plugins/workflow_designer \
          src/plugins/repeat_finder \
          src/plugins/remote_request \
          src/plugins/test_runner \
          src/plugins/perf_monitor \
          src/plugins/smith_waterman \
          src/plugins/smith_waterman2 \
          src/plugins_3rdparty/blast \
          src/plugins_3rdparty/primer3 \
          src/plugins/enzymes \
          src/plugins_3rdparty/umuscle4 \

use_cuda() {
SUBDIRS += src/plugins/cuda_support
}

use_atistream() {
SUBDIRS += src/plugins/atistream_support
}


use_sse2() {
SUBDIRS += src/plugins_3rdparty/hmm3
}

exclude_list_enabled() {
SUBDIRS -= src/plugins/smith_waterman \
           src/plugins_3rdparty/blast \
           src/plugins/atistream_support
}

#create target directories
win32 {
    system( if not exist src\_debug mkdir src\_debug )
    system( if not exist src\_release mkdir src\_release )    
} else {
    system( cd src && [ -d _debug ] || mkdir _debug )
    system( cd src && [ -d _release ] || mkdir _release )
}


#prepare translations
UGENE_TRANSL_IDX   = 0          1
UGENE_TRANSL_FILES = russian.ts english.ts 
UGENE_TRANSL_TAG   = ru         en

UGENE_TRANSL_DIR   = transl
UGENE_TRANSL_QM_TARGET_DIR = src/_debug src/_release

#detecting lrelease binary
win32 : UGENE_DEV_NULL = nul
unix : UGENE_DEV_NULL = /dev/null

UGENE_LRELEASE =
UGENE_LUPDATE = 
system(lrelease -version > $$UGENE_DEV_NULL 2> $$UGENE_DEV_NULL) {
    UGENE_LRELEASE = lrelease
    UGENE_LUPDATE = lupdate
} else : system(lrelease-qt4 -version > $$UGENE_DEV_NULL 2> $$UGENE_DEV_NULL) {
    UGENE_LRELEASE = lrelease-qt4
    UGENE_LUPDATE = lupdate-qt4
}

#foreach 'language'
for( i, UGENE_TRANSL_IDX ) {
    UGENE_TRANSLATIONS = 

    curTranslFile = $$member( UGENE_TRANSL_FILES, $$i )
    curTranslTag  = $$member( UGENE_TRANSL_TAG, $$i )

    #foreach project directory
    for( prj_dir, SUBDIRS ) {
        #look for file and add it to translation list if it exists
        translFile = $$prj_dir/$$UGENE_TRANSL_DIR/$$curTranslFile   # 'project/transl/english.ts' etc.
        exists( $$translFile ) {
            UGENE_TRANSLATIONS += $$translFile
#            system( $$UGENE_LUPDATE $$translFile ) FIXME
        }
    }
    for( targetDir, UGENE_TRANSL_QM_TARGET_DIR ) {
        targetQmFile = $$targetDir/transl_$$curTranslTag            # 'transl_en.qm' etc.
        targetQmFile = $$join( targetQmFile, , , .qm )              # special workaround for adding suffix started with '.'

        !isEmpty(UGENE_LRELEASE) {
            message( Generating traslations for language: $$curTranslTag )
            system( $$UGENE_LRELEASE $$UGENE_TRANSLATIONS -qm $$targetQmFile > $$UGENE_DEV_NULL ) 
        } else {
            message( Can't generate translations: no lrelease binary found )
        }
    }
}


unix {
    system( chmod a+x ./src/gen_bin_script.cmd && ./src/gen_bin_script.cmd $$UGENE_INSTALL_DIR ugene > ugene; chmod a+x ugene )
    system( ./src/gen_bin_script.cmd $$UGENE_INSTALL_DIR congene > congene; chmod a+x congene )
    binscript.files += ugene congene
    binscript.path = $$UGENE_INSTALL_BINDIR

    transl.files = ./src/_release/transl_en.qm ./src/_release/transl_ru.qm
    transl.path = $$UGENE_INSTALL_DIR

    scripts.files += scripts/*
    scripts.path = $$UGENE_INSTALL_DIR/scripts

    data.files += data/*
    data.path = $$UGENE_INSTALL_DATA

    desktop.files += installer/_common_data/ugene.desktop
    desktop.path = $$UGENE_INSTALL_DESKTOP

    icons.files += installer/_common_data/ugene.png installer/_common_data/ugene.xpm
    icons.path = $$UGENE_INSTALL_PIXMAPS

    manual.files += installer/_common_data/ugene.1.gz installer/_common_data/congene.1.gz
    manual.path = $$UGENE_INSTALL_MAN

    INSTALLS += binscript transl scripts data desktop icons manual
}
