/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include <util_dna_assembly/DnaAssemblyTask.h>
#include "DnaAssemblyAlgRegistry.h"

namespace GB2 {

DnaAssemblyAlgRegistry::DnaAssemblyAlgRegistry( QObject* pOwn /*= 0*/ ) : QObject(pOwn)
{

}

DnaAssemblyAlgRegistry::~DnaAssemblyAlgRegistry()
{
    foreach( DnaAssemblyToRefTaskFactory* factory, algMap.values()) {
        delete factory;
    }
}

bool DnaAssemblyAlgRegistry::registerTask( const QString& algId, DnaAssemblyToRefTaskFactory* alg )
{
    QMutexLocker locker(&mutex);

    if (algMap.contains(algId)){	
        return false;
    }
    algMap.insert(algId, alg);	
    return true;

}

bool DnaAssemblyAlgRegistry::hadRegistered( const QString& algId ) const
{
    return algMap.contains(algId);
}

DnaAssemblyToRefTaskFactory* DnaAssemblyAlgRegistry::getTaskFactory( const QString& algId ) const
{
    if (algMap.contains(algId)) {
        return algMap.value(algId);
    } else {
        return NULL;
    }
}

QStringList DnaAssemblyAlgRegistry::getTaskNameList() const
{
    return algMap.keys();
}

DnaAssemblyGUIExtensionFactory* DnaAssemblyAlgRegistry::getGUIExtensionFactory( const QString& algId ) const
{
    if (guiExtMap.contains(algId)) {
        return guiExtMap.value(algId);
    } else {
        return NULL;
    }
}

bool DnaAssemblyAlgRegistry::registerGUIExtension( const QString& algId, DnaAssemblyGUIExtensionFactory* factory )
{
    if (guiExtMap.contains(algId)){	
        return false;
    }
    guiExtMap.insert(algId, factory);	
    return true;   
}

}


