/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/


#ifndef _GB2_PROTOCOL_UI_H_
#define _GB2_PROTOCOL_UI_H_

#include <cassert>

#include <QtCore/QList>
#include <QtGui/QWidget>
#include "RemoteMachine.h"

namespace GB2 {

/*
 * Base class for GUI form with remote machine info
 */
class GB2_COREAPI_EXPORT ProtocolUI : public QWidget {
public:
    ProtocolUI();
    virtual ~ProtocolUI();
    
    // after user clicks 'ok', creates remote machine settings based on the info in the form. Caller should delete it
    virtual RemoteMachineSettings * createMachine() const = 0;
    virtual void initializeWidget( const RemoteMachineSettings *settings ) = 0;
    virtual void clearWidget() = 0;
    virtual QString validate() const = 0;
    
private:
    ProtocolUI( const ProtocolUI & );
    ProtocolUI & operator=( const ProtocolUI & );
    
}; // ProtocolUI

} // GB2

#endif // _GB2_PROTOCOL_UI_H
