/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/


#ifndef _GB2_REMOTE_TASK_H_
#define _GB2_REMOTE_TASK_H_

#include <QtCore/QEventLoop>

#include "LocalTask.h"
#include "RemoteMachine.h"

namespace GB2 {

class RemoteTask;

/*
* We need this because RemoteTask is created in main thread and we cannot send signals to him from another (from QTimer)
*/
class RemoteTaskChanger : public QObject {
    Q_OBJECT
public:
    RemoteTaskChanger( RemoteTask * task );

public slots:
    void sl_RemoteTaskTimerUpdate();
    void sl_isStartedOnRemoteMachine();
    
private:
    RemoteTask * task;

}; // RemoteTaskChanger

/*
 * RemoteTask - task that sends a remote request to run a task.
 * It's state synchronizes with task on remote machine. 
 * When task on remote machine is finished - retrieves result
 */
class GB2_COREAPI_EXPORT RemoteTask : public Task {
    Q_OBJECT
public:
    static const int TIMER_UPDATE_TIME = 2000; /* 2 seconds */
    /* if after this time task is not started -> finish with error */
    static const int TASK_ON_REMOTE_MACHINE_STARTED_TIMEOUT = 30000;
    
public:
    RemoteTask( const QString &localTaskFactoryId, const LocalTaskSettings & settings, RemoteMachine * machine );
    ~RemoteTask();
    
    virtual void run();
    virtual ReportResult report();
    
    LocalTaskResult * getResult();
    bool hasNetworkErrorOccurred() const;
    RemoteMachine * getRemoteMachine() const;
    
    friend class RemoteTaskChanger;
    
private:
    void setRemoteMachineError( const QString & msg );
    void deleteRemoteMachineTask();
    void finilize();
    void deleteRemoteTaskAndFinilize();
    
private:
    QString                             taskFactoryId;
    QVariant                            settings;
    RemoteMachine *                     machine;
    qint64                              taskIdOnRemoteMachine; /* id of a local task that runs on remote machine */
    State                               stateOnRemoteMachine;
    bool                                canceledOnRemoteMachine;
    LocalTaskResult *                   result;
    bool                                networkError;
    QEventLoop *                        eventLoop; /* to recieve timer signals */
    RemoteTaskChanger *                 changer;
    
}; // RemoteTask

} // GB2

#endif // _GB2_REMOTE_TASK_H_
