/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/


#include "RemoteTaskError.h"

namespace GB2 {

RemoteTaskError::RemoteTaskError( bool o, const QString & m )
: ok( o ), msg( m ) {
}

RemoteTaskError::RemoteTaskError( bool o ) : ok( o ), msg( "" ) {
}

RemoteTaskError::RemoteTaskError() : ok( false ), msg( "" ) {
}

bool RemoteTaskError::getOk() const {
    return ok;
}

QString RemoteTaskError::getMsg() const {
    return msg;
}

QVariant RemoteTaskError::serialize() const {
    QVariantList ret;
    ret << ok << msg;
    return ret;
}

bool RemoteTaskError::deserialize( const QVariant & data ) {
    if( !data.canConvert( QVariant::List ) ) {
        return false;
    }
    QVariantList args = data.toList();
    if( 2 != args.size() ) {
        return false;
    }
    if( !args.at( 0 ).canConvert( QVariant::Bool ) ) {
        return false;
    }
    ok = args.at( 0 ).toBool();

    if( !args.at( 1 ).canConvert( QVariant::String ) ) {
        return false;
    }
    msg = args.at( 1 ).toString();

    return true;
}

} // GB2
