/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "VanDerWaalsSurface.h"

namespace GB2 {

// VanDerWaalsSurface

VanDerWaalsSurface::VanDerWaalsSurface()
{
}

void VanDerWaalsSurface::calculate(const QList<SharedAtom> &atoms)
{
    // Van Der Vaals surface calculation
    // based on atom radius (look for neighbours, exclude unneeded atoms)

    foreach (const SharedAtom a, atoms) {
        QList<SharedAtom> neighbors = findAtomNeighbors(a, atoms);
        GeodesicSphere surface = getAtomSurfaceDots(a);
        QVector<Vector3D> surfaceDots = surface.getVertices();
        QVector<Vector3D> reducedVertices;
        foreach (const Vector3D& v, surfaceDots) {
            if ( vertexNeighboursOneOf(v, neighbors) ) {
                continue;
            } else {
                reducedVertices.append(v);
            }
        }
        QVector<Face> surfaceFaces = surface.getFaces();
        foreach (const Face& face, surfaceFaces) {
            if ( reducedVertices.contains(face.v[0]) || reducedVertices.contains(face.v[1]) || reducedVertices.contains(face.v[2]) ) {
                faces.append(face);
            }
        }
    }
}

void VanDerWaalsSurface::calculate(const BioStruct3D& bioStruct)
{
    Vector3D center = bioStruct.getCenter();
    float radius = bioStruct.getMaxDistFromCenter();
    GeodesicSphere sphere(center, radius);
    vertices = sphere.getVertices();
}

// VanDerWaalsSurfaceFactory

MolecularSurface *VanDerWaalsSurfaceFactory::createInstance()const
{
    return new VanDerWaalsSurface();
}

} // namespace GB2
