/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _PHYTREEGENERATOR
#define _PHYTREEGENERATOR


#include <core_api/Task.h>
#include <datatype/PhyTree.h>
#include <datatype/MAlignment.h>
#include "phyltree/CreatePhyTreeSettings.h"

#include <memory>



namespace GB2{

class CreatePhyTreeDialogController;

class GB2_COREAPI_EXPORT PhyTreeGenerator{
public:
    virtual PhyTree calculatePhyTree(const MAlignment& ma, const CreatePhyTreeSettings& s, TaskStateInfo& ti) = 0;
    virtual void setupCreatePhyTreeUI(CreatePhyTreeDialogController* c, const MAlignment& ma) = 0;
};



}
#endif
