/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "AddPartToSequenceTests.h"

#include <util_tasks/LoadDocumentTask.h>

#include <core_api/AppContext.h>

#include <gobjects/AnnotationTableObject.h>

namespace GB2{
#define DOC_NAME_ATTR "doc_name"
#define SEQ_NAME_ATTR "seq_name"
#define START_POS_ATTR "start_pos"
#define INSERTED_SEQ_ATTR "inserted_sequence"
#define ANNOTATION_NAME_ATTR "annotation_name"
#define EXPECTED_SEQ_ATTR "expected_sequence"
#define EXPECTED_REGIONS_ATTR "expected_regions"
#define EXPECTED_ANNOTATION_STRATEGY_ATTR "annotation_processing"

void GTest_AddPartToSequenceTask::init(XMLTestFormat *tf, const QDomElement& el){
    Q_UNUSED(tf);
    QString buf;
    buf = el.attribute(DOC_NAME_ATTR);
    if (!buf.isEmpty()){
        docName=buf;
    }
    buf = el.attribute(SEQ_NAME_ATTR);
    if (!buf.isEmpty()){
        seqName=buf;
    }
    buf = el.attribute(START_POS_ATTR);
    if (!buf.isEmpty()){
        startPos=buf.toInt();
    }
    buf = el.attribute(INSERTED_SEQ_ATTR);
    if (!buf.isEmpty()){
        insertedSequence=buf;
    }
    buf = el.attribute(ANNOTATION_NAME_ATTR);
    if (!buf.isEmpty()){
        annotationName=buf;
    }
    buf = el.attribute(EXPECTED_SEQ_ATTR);
    if (!buf.isEmpty()){
        expectedSequence=buf;
    }
    buf = el.attribute(EXPECTED_REGIONS_ATTR);
    if (!buf.isEmpty()){
        foreach(QString str,buf.split(' ',QString::SkipEmptyParts)){
            expectedRegions.append(LRegion(str.split(',')[0].toInt(),str.split(',')[1].toInt()-str.split(',')[0].toInt()));
        }
        //expectedRegions=buf;
    }else{
        expectedRegions.clear();
    }
    buf = el.attribute(EXPECTED_ANNOTATION_STRATEGY_ATTR);
    if(buf.toLower() == "remove"){
        strat = AddPartToSequenceTask::AnnotationStrategyForAdd_Remove;
    }else if(buf.toLower() == "resize"){
        strat = AddPartToSequenceTask::AnnotationStrategyForAdd_Resize;
    }else if(buf.toLower() == "split"){
        strat = AddPartToSequenceTask::AnnotationStrategyForAdd_Split;
    }else{
        strat = AddPartToSequenceTask::AnnotationStrategyForAdd_Resize;
    }
}

void GTest_AddPartToSequenceTask::prepare(){
    Document* loadedDocument = getContext<Document>(this, docName);
    if (loadedDocument == NULL) {
        stateInfo.setError(GTest::tr("context not found %1").arg(docName));
        return;
    }
    dnaso=(DNASequenceObject*)loadedDocument->findGObjectByName(seqName);
    if (dnaso==NULL){
        stateInfo.setError(GTest::tr("Sequence %1 not found").arg(seqName));
    }else{
        QList<Document*> docList;
        docList.append(loadedDocument);
        DNASequence seqToIns("test", insertedSequence.toAscii(), AppContext::getDNAAlphabetRegistry()->findAlphabet(insertedSequence.toAscii()));
        AddPartToSequenceTask* t=new AddPartToSequenceTask(loadedDocument->getDocumentFormatId(), dnaso, startPos, seqToIns, strat);
        addSubTask(t);
    }
}

Task::ReportResult GTest_AddPartToSequenceTask::report(){
    if (dnaso->getSequenceLen()!=expectedSequence.size())
    {
        stateInfo.setError(GTest::tr("Length of sequence is incorrect. Expected:%2, but Actual:%1")
            .arg(dnaso->getSequenceLen())
            .arg(expectedSequence.length()));
        return ReportResult_Finished;
    }
    if (QString::compare ( dnaso->getSequence(), expectedSequence, Qt::CaseInsensitive)!=0)//may be refactor this place
    {
        stateInfo.setError(GTest::tr("Sequence is incorrect. Expected:%1, but Actual:%2")
            .arg((QString)(dnaso->getSequence()))
            .arg(expectedSequence));
        return ReportResult_Finished;
    }
    if (annotationName.length()!=0)
    {
        Document* loadedDocument = getContext<Document>(this, docName);
        QList<GObject*> annotationTablesList = loadedDocument->findGObjectByType(GObjectTypes::ANNOTATION_TABLE);
        foreach(GObject *table, annotationTablesList){
            AnnotationTableObject *ato = (AnnotationTableObject*)table;
            foreach(Annotation* curentAnnotation,ato->getAnnotations()){
                if (curentAnnotation->getAnnotationName() == annotationName){
                    int i=0;
                    if(curentAnnotation->getLocation().size() != expectedRegions.size()){
                        stateInfo.setError(GTest::tr("Regions is incorrect. Expected size:%1 Actual size:%2").arg(expectedRegions.size()).arg(curentAnnotation->getLocation().size()));
                    }
                    if(expectedRegions.size() == 0){
                        return ReportResult_Finished;
                    }
                    foreach(LRegion curRegion,curentAnnotation->getLocation()){
                        if (curRegion!=expectedRegions.at(i))
                        {
                            stateInfo.setError(GTest::tr("Regions is incorrect. Expected:%3,%4, but Actual:%1,%2")
                                .arg(curRegion.startPos).arg(curRegion.endPos())
                                .arg(expectedRegions.at(i).startPos).arg(expectedRegions.at(i).endPos()));
                            return ReportResult_Finished;
                        }
                        i++;
                    }
                }
            }
        }
    }
    
    return ReportResult_Finished;
}


GTest_AddPartToSequenceTask::~GTest_AddPartToSequenceTask() {      

}


QList< XMLTestFactory* > AddPartToSequenceTests::createTestFactories()
{
    QList< XMLTestFactory* > res;
    res.append( GTest_AddPartToSequenceTask::createFactory() );
    return res;
}

}
