/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_SARRAY_BASED_FIND_TASK_H_
#define _GB2_SARRAY_BASED_FIND_TASK_H_

#include <core_api/Task.h>
#include <core_api/LRegion.h>

#include <QtCore/QMutex>

#include "BitsTable.h"

namespace GB2 {

class SArrayIndex;

struct GB2_COREAPI_EXPORT SArrayBasedSearchSettings {
    SArrayBasedSearchSettings() : query(""), useBitMask(false), unknownChar('\0'),
        bitMask(NULL), nMismatches(0) {}
    QByteArray query;
    bool useBitMask;
    char unknownChar;
    quint32 bitMaskCharBitsNum;
    const quint32*  bitMask;
    int nMismatches;
}; 

class GB2_COREAPI_EXPORT SArrayBasedFindTask : public Task {
    Q_OBJECT
public:
    SArrayBasedFindTask(SArrayIndex* i, const SArrayBasedSearchSettings& s);
    virtual void run();
    const SArrayBasedSearchSettings& getSettings() const {return config;}
    const QList<int> getResults() const { return results; }

private:
    void runSearch();
    void runSearchWithMismatches();
    SArrayIndex* index;
    SArrayBasedSearchSettings config;
    QList<int> results;
    QMutex lock;
};

} //namespace

#endif // _GB2_SARRAY_BASED_FIND_TASK_H_