/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "CopyDocumentDialogController.h"
#include "SaveDocumentGroupController.h"

#include "util_gui/DialogUtils.h"

#include <core_api/AppContext.h>
#include <core_api/GObject.h>
#include <core_api/GUrlUtils.h>
#include <core_api/DocumentUtils.h>

#include <QtCore/QDir>
#include <QtCore/QFileInfo>
#include <QtGui/QFileDialog>

namespace GB2{

CopyDocumentDialogController::CopyDocumentDialogController(Document* d, QWidget *p) : QDialog(p) {
    setupUi(this);

    SaveDocumentGroupControllerConfig conf;
    foreach (GObject* obj, d->getObjects()) {
        conf.dfc.supportedObjectTypes+=obj->getGObjectType();
    }
    conf.dfc.addFlagToSupport(DocumentFormatFlag_SupportWriting);
    conf.fileDialogButton = browseButton;
    conf.fileNameEdit = fileNameEdit;
    conf.formatCombo = formatCombo;
    conf.parentWidget = this; 

    saveController = new SaveDocumentGroupController(conf, this);

    QString fileName = GUrlUtils::rollFileName(d->getURLString(), "_copy", DocumentUtils::getNewDocFileNameExcludesHint());
    fileNameEdit->setText(fileName);
}

QString CopyDocumentDialogController::getDocumentURL() const {
    return saveController->getSaveFileName();
}

DocumentFormatId CopyDocumentDialogController::getDocumentFormatId() const {
    return saveController->getFormatIdToSave();
}

}//namespace
