/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_COPY_DOCUMENT_DIALOG_CONTROLLER_H_
#define _GB2_COPY_DOCUMENT_DIALOG_CONTROLLER_H_

#include "ui/ui_CopyDocumentDialog.h"

#include <core_api/core_api.h>
#include <core_api/DocumentModel.h>
#include <core_services/DocumentFormatRegistryImpl.h>

namespace GB2 {

class SaveDocumentGroupController;

class GB2_COREAPI_EXPORT CopyDocumentDialogController : public QDialog, public Ui_CopyDocumentDialog {
    Q_OBJECT
public:
    CopyDocumentDialogController(Document* d, QWidget* p);

    QString getDocumentURL() const;
    
    bool getAddToProjectFlag() const {return addToProjCheck->isChecked();}

    DocumentFormatId getDocumentFormatId() const;

private:
    SaveDocumentGroupController* saveController;
};

}//ns

#endif
