/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "CreateObjectRelationDialogController.h"

#include <gobjects/DNASequenceObject.h>
#include <gobjects/AnnotationTableObject.h>
#include <gobjects/GObjectRelationRoles.h>
#include <gobjects/GObjectTypes.h>

#include <QtGui/QIcon>
#include <QtGui/QMessageBox>

namespace GB2 {

CreateObjectRelationDialogController::CreateObjectRelationDialogController(GObject* _assObj, const QList<GObject*>& _objects, 
                                                                           const QString& _role, bool rd, QWidget* p)
: QDialog(p), selectedObject(NULL), assObj(_assObj), objects(_objects), role(_role), removeDuplicates(rd)
{
    assert(!objects.isEmpty());
    assert(!role.isEmpty());
    assert(assObj!=NULL);

    setupUi(this);

    QIcon objectIcon(":/core/images/gobject.png");
    foreach(GObject* obj, objects) {
        listWidget->addItem(new QListWidgetItem(objectIcon, obj->getGObjectName()));        
    }
    listWidget->setItemSelected(listWidget->item(0), true);
}

void CreateObjectRelationDialogController::accept() {
    int idx = listWidget->currentRow();
    assert(idx>=0 && idx < objects.size());
    
    GObject* selObj = objects[idx];
    if (role == GObjectRelationRole::SEQUENCE && assObj->getGObjectType() == GObjectTypes::ANNOTATION_TABLE) {
        DNASequenceObject* dnaObj = qobject_cast<DNASequenceObject*>(selObj);
        AnnotationTableObject* ao = qobject_cast<AnnotationTableObject*>(assObj);
        AnnotationTableObjectConstraints c;
        c.sequenceSizeToFit = dnaObj->getSequenceLen();
        bool res = ao->checkConstraints(&c);
        if (!res) {
            int rc = QMessageBox::question(this, tr("Warning"), 
                tr("Found annotations that are out of the sequence range, continue?"), QMessageBox::Yes, QMessageBox::No);
            if (rc == QMessageBox::No) {
                return;
            }
        }
        if (removeDuplicates) {
            QList<GObjectRelation> oldRel = assObj->findRelatedObjectsByRole(role);
            foreach(const GObjectRelation& r, oldRel) {
                assObj->removeObjectRelation(r);
            }
        }
        assObj->addObjectRelation(selObj, role);
    }

    selectedObject = selObj;
    QDialog::accept();
}

}//namespace
