/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/


#ifndef _GB2_UINDEX_SUPPORT_H_
#define _GB2_UINDEX_SUPPORT_H_

#include <core_api/core_api.h>

#include <QtCore/QObject>
#include <ui/ui_CreateFileIndexDialog.h>

namespace GB2 {

class GB2_COREAPI_EXPORT UIndexSupport : public QObject {
    Q_OBJECT
public:
    UIndexSupport();
    
private slots:
    void sl_showCreateFileIndexDialog();
    
}; // UIndexSupport

struct CreateFileIndexDialogModel {
    QString inputUrl;
    QString outputUrl;
    bool    gzippedOutput;
}; // CreateFileIndexDialogModel

class CreateFileIndexDialog : public QDialog, Ui_CreateFileIndexDialog {
    Q_OBJECT
public:
    CreateFileIndexDialog(QWidget* p);
    
    CreateFileIndexDialogModel getModel() const;

    virtual void accept();

private:
    CreateFileIndexDialogModel model;
    
private slots:
    void sl_openInputFile();
    void sl_openOutputFile();
    
};

} // GB2

#endif // _GB2_UINDEX_SUPPORT_H_
