/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_MSA_CONSENSUS_ALGORITHM_DEFAULT_H_
#define _GB2_MSA_CONSENSUS_ALGORITHM_DEFAULT_H_

#include "MSAConsensusAlgorithm.h"
#include "BuiltInConsensusAlgorithms.h"

namespace GB2 {

// Default algorithm is based on JalView experience. It also makes letters with low threshold lowercase
class GB2_COREAPI_EXPORT MSAConsensusAlgorithmFactoryDefault: public MSAConsensusAlgorithmFactory {
    Q_OBJECT
public:
    MSAConsensusAlgorithmFactoryDefault(QObject* p = NULL);
            
    virtual MSAConsensusAlgorithm* createAlgorithm(const MAlignment& ma, QObject* parent);

    virtual QString getDescription() const;

    virtual QString getName() const;

    virtual LRegion getThresholdRange() const {return LRegion(1, 99);}

    virtual int getDefaultThreshold() const {return 100;}

    virtual QString getThresholdSuffix() const {return QString("%");}

};


class GB2_COREAPI_EXPORT MSAConsensusAlgorithmDefault : public MSAConsensusAlgorithm {
	Q_OBJECT
public:
	MSAConsensusAlgorithmDefault(MSAConsensusAlgorithmFactoryDefault* f, QObject* p = NULL) 
		: MSAConsensusAlgorithm(f, p){}

    virtual char getConsensusChar(const MAlignment& ma, int column) const {
		int countStub = 0;
		return getConsensusCharAndScore(ma, column, countStub);
	}

	virtual char getConsensusCharAndScore(const MAlignment& ma, int column, int& score) const;
};

}//namespace

#endif
