/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_LOAD_DOCUMENT_TASK_H_
#define _GB2_LOAD_DOCUMENT_TASK_H_

#include <core_api/Task.h>
#include <core_api/GUrl.h>
#include <core_api/GObjectReference.h>

#include <QtCore/QPointer>
#include <QtCore/QVariantMap>

namespace GB2 {

class Document;
class DocumentFormat;
class IOAdapterFactory;
class StateLock;
class LoadDocumentTask;

// creates object using name and type info from ref
//NOTE: the default impl can create only limited set of objects
class GB2_COREAPI_EXPORT LDTObjectFactory : public QObject {
public:
    LDTObjectFactory(QObject* p) : QObject(p){}
    virtual GObject* create(const GObjectReference& ref);
};

class GB2_COREAPI_EXPORT LoadDocumentTaskConfig {
public:
    LoadDocumentTaskConfig(bool _createDoc = false, const GObjectReference& _ref = GObjectReference(), LDTObjectFactory* _f = NULL)
        : createDoc(_createDoc), checkObjRef(_ref), objFactory(_f) {}

    bool                createDoc;      // if document is failed to load and 'createDoc' is true -> it will be created
    GObjectReference    checkObjRef;    // if is valid task checks that ref is found in doc, fails if not
    LDTObjectFactory*   objFactory;     // if not NULL and 'checkObjRef' is not found -> 'objFactory' is used to create obj
};

class GB2_COREAPI_EXPORT LoadUnloadedDocumentTask : public Task {
    Q_OBJECT
public:
	LoadUnloadedDocumentTask(Document* d, const LoadDocumentTaskConfig& config = LoadDocumentTaskConfig());
    
	virtual void prepare();
	virtual ReportResult report();

    static QString getResourceName(Document* d);
   
    Document* getDocument() const;
    const LoadDocumentTaskConfig& getConfig() const {return config;}
    
    static LoadUnloadedDocumentTask* findActiveLoadingTask(Document* d);
    static bool addLoadingSubtask(Task* t, const LoadDocumentTaskConfig& config);

private:
    void clearResourceUse();
    
	class LoadDocumentTask* subtask;
	QPointer<Document>      unloadedDoc;
    QString                 resName;
    LoadDocumentTaskConfig  config;
};

class GB2_COREAPI_EXPORT LoadDocumentTask : public Task {
    Q_OBJECT
public:
    static LoadDocumentTask * getDefaultLoadDocTask( const GUrl & url );
    
public:
	LoadDocumentTask(DocumentFormatId format, const GUrl& url, 
                IOAdapterFactory* iof, const QVariantMap& hints = QVariantMap(), 
                const LoadDocumentTaskConfig& config = LoadDocumentTaskConfig());

	~LoadDocumentTask();
	
	virtual void run();
	virtual ReportResult report();
    virtual void cleanup();

	Document* getDocument() const {return result;}
	Document* takeDocument() {Document* d = result; result = NULL; return d;}
    const GUrl& getURL() const {return url;}

private:
    void processObjRef();

	DocumentFormatId    format;
	const GUrl			url;
	IOAdapterFactory*   iof;
    QVariantMap         hints;
	Document*           result;
    LoadDocumentTaskConfig  config;
};

class GB2_COREAPI_EXPORT LoadUnloadedDocumentAndOpenViewTask : public Task {
    Q_OBJECT
public:
    LoadUnloadedDocumentAndOpenViewTask(Document* d);
    
protected:
    virtual QList<Task*> onSubTaskFinished(Task* subTask);

private:
    void clearResourceUse();

    class LoadUnloadedDocumentTask* loadUnloadedTask;
};

}//namespace

#endif
