/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include <cassert>
#include <QtCore/QStringList>

#include <workflow_support/WorkflowUtils.h>

#include "ConfigurationEditor.h"
#include "Configuration.h"

namespace GB2 {

Configuration::Configuration() : editor(NULL), validator(NULL) {
}

Configuration::~Configuration() {
    qDeleteAll(params.values());
}

QMap<QString, Attribute*> Configuration::getParameters() const {
    return params;
}

Attribute * Configuration::getParameter(const QString & name) const {
    return params.value(name);
}

Attribute * Configuration::removeParameter( const QString & name ) {
    return params.take(name);
}

void Configuration::addParameter( const QString & name, Attribute * attr ) {
    assert(attr != NULL);
    params[name] = attr;
}

void Configuration::setParameter(const QString& name, const QVariant& val) {
    if(params.contains(name)) {
        params[name]->setAttributeValue(val);
    }
}

bool Configuration::hasParameter(const QString & name) const {
    return params.contains(name);
}

ConfigurationEditor * Configuration::getEditor() {
    return editor;
}

void Configuration::setEditor(ConfigurationEditor* ed) {
    assert(ed != NULL);
    editor = ed;
}

ConfigurationValidator * Configuration::getValidator() {
    return validator;
}

void Configuration::setValidator(ConfigurationValidator* v) {
    assert(v != NULL);
    validator = v;
}

bool Configuration::validate(QStringList& l) const {
    bool good = true;
    foreach(Attribute* a, getParameters()) {
        if (a->isRequiredAttribute() && (!a->getAttributePureValue().isValid() || a->getAttributePureValue().isNull())) 
        {
            good = false;
            l.append(GB2::DesignerUtils::tr("Required parameter is not set: %1").arg(a->getDisplayName()));
        }
    }
    if (validator) {
        good &= validator->validate(this, l);
    }
    return good;
}

void Configuration::setParameters(const QVariantMap& cfg)
{
    QMapIterator<QString,QVariant> it(cfg);
    while (it.hasNext())
    {
        it.next();
        setParameter(it.key(), it.value());
    }
}

} // GB2
