/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "BioDatatypes.h"

#include <workflow/WorkflowEnv.h>
#include <workflow_support/CoreDataTypes.h>
#include <workflow/Datatype.h>

namespace GB2 {

const QString BioDataTypes::DNA_SEQUENCE_TYPE_ID("seq");
const QString BioDataTypes::ANNOTATION_TYPE_ID("ann");
const QString BioDataTypes::ANNOTATION_TABLE_LIST_TYPE_ID("ann-table-list");
const QString BioDataTypes::ANNOTATION_TABLE_TYPE_ID("ann-table");
const QString BioDataTypes::DNA_CHROMATOGRAM_TYPE_ID("chromatogram");
const QString BioDataTypes::MULTIPLE_ALIGNMENT_TYPE_ID("multi-alig");

using namespace Workflow;

DataTypePtr BioDataTypes::DNA_SEQUENCE_TYPE() {
    DataTypeRegistry* dtr = WorkflowEnv::getDataTypeRegistry();
    assert(dtr);
    static bool startup = true;
    if (startup)
    {
        dtr->registerEntry(DataTypePtr(new DataType(DNA_SEQUENCE_TYPE_ID, tr("Sequence"), tr("A sequence"))));
        startup = false;
    }
    return dtr->getById(DNA_SEQUENCE_TYPE_ID);
}

DataTypePtr BioDataTypes::ANNOTATION_TYPE() {
    DataTypeRegistry* dtr = WorkflowEnv::getDataTypeRegistry();
    assert(dtr);
    static bool startup = true;
    if (startup)
    {
        dtr->registerEntry(DataTypePtr(new DataType(ANNOTATION_TYPE_ID, tr("Annotation"), tr("An annotation of a sequence region"))));
        startup = false;
    }
    return dtr->getById(ANNOTATION_TYPE_ID);
}

DataTypePtr BioDataTypes::ANNOTATION_TABLE_TYPE() {
    DataTypeRegistry* dtr = WorkflowEnv::getDataTypeRegistry();
    assert(dtr);
    static bool startup = true;
    if (startup)
    {
        dtr->registerEntry(DataTypePtr(new DataType(ANNOTATION_TABLE_TYPE_ID, tr("Set of DNA annotations"), tr("A set of annotated features in a DNA sequence"))));
        startup = false;
    }
    return dtr->getById(ANNOTATION_TABLE_TYPE_ID);
}

DataTypePtr BioDataTypes::ANNOTATION_TABLE_LIST_TYPE() {
    DataTypeRegistry* dtr = WorkflowEnv::getDataTypeRegistry();
    assert(dtr);
    static bool startup = true;
    if (startup)
    {
        dtr->registerEntry(DataTypePtr(new ListDataType(
            Descriptor(ANNOTATION_TABLE_LIST_TYPE_ID, tr("List of Annotations"), tr("A list of DNA sequence annotations")), 
            BioDataTypes::ANNOTATION_TABLE_TYPE())));
        startup = false;
    }
    return dtr->getById(ANNOTATION_TABLE_LIST_TYPE_ID);
}

DataTypePtr BioDataTypes::DNA_CHROMATOGRAM_TYPE() {
    DataTypeRegistry* dtr = WorkflowEnv::getDataTypeRegistry();
    assert(dtr);
    static bool startup = true;
    if (startup)
    {
        dtr->registerEntry(DataTypePtr(new DataType(DNA_CHROMATOGRAM_TYPE_ID, tr("Chromatogram"), tr("A sequence chromatogram"))));
        startup = false;
    }
    return dtr->getById(DNA_CHROMATOGRAM_TYPE_ID);
}

DataTypePtr BioDataTypes::MULTIPLE_ALIGNMENT_TYPE() {
    DataTypeRegistry* dtr = WorkflowEnv::getDataTypeRegistry();
    assert(dtr);
    static bool startup = true;
    if (startup)
    {
        dtr->registerEntry(DataTypePtr(new DataType(MULTIPLE_ALIGNMENT_TYPE_ID, tr("Multiple Aligment"), tr("Aligned set of sequences"))));
        startup = false;
    }
    return dtr->getById(MULTIPLE_ALIGNMENT_TYPE_ID);
}

} //namespace
