/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/


#ifndef _GB2_WORKFLOW_CORE_LIB_CONSTANTS_H_
#define _GB2_WORKFLOW_CORE_LIB_CONSTANTS_H_

#include <QtCore/QObject>

#include <workflow/Descriptor.h>

namespace GB2 {

namespace Workflow {

class WCOREAPI_EXPORT CoreLibConstants : public QObject {
    Q_OBJECT
public:
    static const QString WRITE_FASTA_ACTOR;
    static const QString READ_TEXT_ACTOR;
    static const QString WRITE_TEXT_ACTOR;
    static const QString WRITE_GENBANK_ACTOR;
    static const QString WRITE_FASTQ_ACTOR;

    static const QString GENERIC_READ_MA_ACTOR;
    static const QString GENERIC_READ_SEQ_ACTOR;

    static const QString WRITE_CLUSTAL_ACTOR;

    static const QString WRITE_STOCKHOLM_ACTOR;
    
    static const QString WRITE_MSA_ACTOR;
    static const QString WRITE_SEQ_ACTOR;
    
    static const QString DATA_PORT_ID;
    static const QString IN_PORT_ID;
    static const QString OUT_PORT_ID;
    
    static const QString URL_IN_ATTR_ID; // input file(s)
    static const QString URL_OUT_ATTR_ID; // output file
    static const QString URL_LOCATION_ATTR_ID; // file(s) located on this or remote computer
    static const QString APPEND_ATTR_ID;
    static const QString DOCUMENT_FORMAT_ATTR_ID;
    static const QString URL_SLOT_ID;
    static const QString FASTA_HEADER_SLOT_ID;
    static const QString GENBANK_ACN_SLOT_ID;
    
    static const QString FASTQ_TYPESET_ID;
    static const QString FASTA_TYPESET_ID;
    static const QString SEQ_TYPESET_ID;
    static const QString GENBANK_TYPESET_ID;
    static const QString TEXT_TYPESET_ID;
    static const QString MA_TYPESET_ID;
    
    static const Descriptor URL_IN_ATTR();
    static const Descriptor URL_OUT_ATTR();
    static const Descriptor READ_URL_SLOT();
    static const Descriptor URL_LOCATION_ATTR();
    static const Descriptor WRITE_URL_SLOT();
    
}; // CoreLibConstants

} // Workflow

} // GB2

#endif // _GB2_WORKFLOW_CORE_LIB_CONSTANTS_H_
