/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef DIRECTSOCKETPLUGIN_H
#define DIRECTSOCKETPLUGIN_H

#include <memory>
#include <core_api/PluginModel.h>
#include <distributed_computing/ProtocolInfo.h>
#include "DirectSocketProtocolUI.h"
#include "DirectSocketRemoteMachine.h"
#include "DirectSocketRemoteTaskServer.h"
#include "DirectSocketScanner.h"

namespace GB2 {

class DirectSocketPlugin : public Plugin {
    Q_OBJECT
public:
    static const QString DIRECT_SOCKET_PROTOCOL_ID;
    
public:
    DirectSocketPlugin();
    virtual ~DirectSocketPlugin();

private:
    std::auto_ptr<DirectSocketProtocolUI> protocolUI;
    DirectSocketRemoteMachineFactory remoteMachineFactory;
    DirectSocketRemoteTaskServer remoteTaskServer;
    DirectSocketScanner remoteMachineScanner;
    ProtocolInfo protocolInfo;
};

} // namespace GB2

#endif // DIRECTSOCKETPLUGIN_H
