/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "DNAExportPlugin.h"
#include "DNAExportPluginTests.h"

#include "ExportProjectViewItems.h"
#include "ExportSequenceViewItems.h"
#include "ImportQualityScoresWorker.h"

#include <core_api/AppContext.h>
#include <util_algorithm/GAutoDeleteList.h>

#include <test_framework/xmltest/XMLTestFormat.h>
#include <test_framework/GTestFrameworkComponents.h>

namespace GB2 {

extern "C" Q_DECL_EXPORT Plugin* GB2_PLUGIN_INIT_FUNC() {
    DNAExportPlugin* plug = new DNAExportPlugin();
    return plug;
}

DNAExportPlugin::DNAExportPlugin() : Plugin(tr("dna_export_name"), tr("dna_export_desc")) {
    if (AppContext::getMainWindow()) {
        services.push_back(new DNAExportService());
    }

    //tests
    GTestFormatRegistry* tfr = AppContext::getTestFramework()->getTestFormatRegistry();
    XMLTestFormat *xmlTestFormat = qobject_cast<XMLTestFormat*>(tfr->findFormat("XML"));
    assert(xmlTestFormat!=NULL);

    GAutoDeleteList<XMLTestFactory>* l = new GAutoDeleteList<XMLTestFactory>(this);
    l->qlist = DNAExportPluginTests::createTestFactories();

    foreach(XMLTestFactory* f, l->qlist) { 
        bool res = xmlTestFormat->registerTestFactory(f);
        assert(res); Q_UNUSED(res);
    }
    
    LocalWorkflow::ImportPhredQualityWorkerFactory::init();
}

//////////////////////////////////////////////////////////////////////////
// Service
DNAExportService::DNAExportService() 
: Service(Service_DNAExport, tr("dna_export_service_name"), tr("dna_export_service_desc"), QList<ServiceType>() << Service_ProjectView)
{
    projectViewController = NULL;
    sequenceViewController = NULL;
}

void DNAExportService::serviceStateChangedCallback(ServiceState oldState, bool enabledStateChanged) {
    Q_UNUSED(oldState);

    if (!enabledStateChanged) {
        return;
    }
    if (isEnabled()) {
        projectViewController = new ExportProjectViewItemsContoller(this);
        sequenceViewController = new ExportSequenceViewItemsController(this);
        sequenceViewController->init();
    } else {
        delete projectViewController; projectViewController = NULL;
        delete sequenceViewController; sequenceViewController = NULL;
    }
}


}//namespace
