/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_ORF_MARKER_TESTS_H_
#define _GB2_ORF_MARKER_TESTS_H_

#include <test_framework/xmltest/XMLTestUtils.h>
#include <test_framework/xmltest/XMLTestUtils.h>
#include <core_api/GObject.h>
#include <QtXml/QDomElement>
#include <test_framework/xmltest/DocumentModelTests.h>
#include <core_api/LRegion.h>
#include <gobjects/AnnotationTableObject.h>
#include <util_ov_annotated_dna/AnnotatedDNAView.h>
#include <util_algorithm/ORFAlgorithmTask.h>

#include <core_api/DNAAlphabet.h>
#include <core_api/DNATranslation.h>
#include <core_api/AppContext.h>

namespace GB2 {

class GTest_ORFMarkerTask : public GTest {
    Q_OBJECT
public:
    SIMPLE_XML_TEST_BODY_WITH_FACTORY(GTest_ORFMarkerTask, "plugin_orf-marker-search");

    void prepare();
    Task::ReportResult report();
private:
    QString seqName;
    QString translationId;
    ORFAlgorithmSettings settings;
    QList<LRegion> expectedResults;
    ORFFindTask *task;
};

//FIXME! this class is a partial copy of DetView
class Translator {
public:
    Translator(const DNASequenceObject *s, const QString& tid);

    //void setAminoTranslation(const QString& id);
    DNATranslation* getComplTranslation() const {return complTransl;}
    DNATranslation* getAminoTranslation() const {return aminoTransl;}

private:
    //QStringList translations;
    const DNASequenceObject* seq;
    DNATranslation* complTransl;
    DNATranslation* aminoTransl;

};

} //namespace
#endif

