/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "stdint.h"
#include <datatype/MAlignment.h>
#include <datatype/DNASequence.h>

#include "BowtieIOAdapter.h"
#include "BowtieContext.h"

#include <QtCore/QMutexLocker>
/************************************************************************/
/* DNASequencesPatternSource                                            */

/************************************************************************/
DNASequencesPatternSource::DNASequencesPatternSource( uint32_t seed, const QList<GB2::DNASequence>& _dnaList )
 :PatternSource(seed), dnaList(_dnaList)
{
  //do nothing
}

void DNASequencesPatternSource::nextReadImpl( ReadBuf& r, uint32_t& patid )
{
  {
	QMutexLocker lock(&mutex);
	if(! (readCnt_ < (unsigned)dnaList.count())) return;

	patid = readCnt_;

	readCnt_ ++;
  }

  BowtieContext::getContext()->ti.progress = ((float)patid) / dnaList.count() * 100;

  r.clearAll();

  BowtieContext::Search* ctx = BowtieContext::getSearchContext();

  const GB2::DNASequence& dna = dnaList[patid];
  

  bool doquals = false; //TODO: quals

  int nameLen = dna.getName().length();
  strcpy(r.nameBuf, dna.getName().toAscii().constData());
  _setBegin(r.name, r.nameBuf);
  _setLength(r.name, nameLen);

  if(nameLen == 0) {
	  itoa10(readCnt_, r.nameBuf);
	  _setBegin(r.name, r.nameBuf);
	  nameLen = strlen(r.nameBuf);
	  _setLength(r.name, nameLen);
  }

  const char* row = dna.seq.constData();
  const int seqLen = dna.length();
  if(seqLen+1 > 1024) {
      tooManySeqChars(r.name);
  }
  
  //TODO: trim;
  r.trimmed3 = 0;
  r.trimmed5 = 0;
  r.color = ctx->color;
  //TODO: if(color) ...
  for(int i=0;i<seqLen;i++) {
    char c =  row[i];
    if(c == '.') c = 'N';
    r.patBufFw[i] = charToDna5[(int)c];
  }
  if(!doquals) {
	  if(!dna.quality.isEmpty()) {
		  switch(dna.quality.type) {
			  case GB2::DnaQualityType_Solexa: 
				  for(int i=0;i<seqLen;i++) r.qualBuf[i] = solexaToPhred(dna.quality.getValue(i)+33); break;
			  case GB2::DNAQualityType_Sanger: 
				  for(int i=0;i<seqLen;i++) r.qualBuf[i] = dna.quality.getValue(i)+33; break;
			  default: for(int i=0;i<seqLen;i++) r.qualBuf[i] = 'I';
		  }
	  } else {
		  for(int i=0;i<seqLen;i++) r.qualBuf[i] = 'I';
	  }
  }
  _setBegin (r.patFw, (Dna5*)r.patBufFw);
  _setLength(r.patFw, seqLen);
  _setBegin (r.qual,  r.qualBuf);
  _setLength(r.qual,  seqLen);

  //r.readOrigBufLen = fb_.copyLastN(r.readOrigBuf);
}

void DNASequencesPatternSource::nextReadPairImpl( ReadBuf& ra, ReadBuf& rb, uint32_t& patid )
{
  Q_UNUSED(ra);
  Q_UNUSED(rb);
  Q_UNUSED(patid);
  throw 1;
}

/************************************************************************/
/* MAlignmentHitSink                                                    */
/************************************************************************/

MAlignmentHitSink::MAlignmentHitSink( GB2::MAlignment& _resultMA, OutFileBuf* out, DECL_HIT_DUMPS, bool onePairFile, bool sampleMax, RecalTable *table, vector<string>* refnames /*= NULL*/ )
  :HitSink(out, PASS_HIT_DUMPS, onePairFile, sampleMax, table,refnames), resultMA(_resultMA)
{
  //do nothing
}

void MAlignmentHitSink::append( ostream& o, const Hit& h )
{
  Q_UNUSED(o);
  QMutexLocker lock(&mutex);
  QByteArray name(h.patName.data_begin, length(h.patName));
  QByteArray sequence;
  QByteArray quality;
  const int seqLen = length(h.patSeq);
  for(int i=0; i < seqLen; i++) {
	  char qryChar = (h.fw ? h.patSeq[i] : h.patSeq[seqLen-i-1]);
	  char qualChar = (h.fw ? h.quals[i] : h.quals[seqLen-i-1]);
	  sequence.append(qryChar);
	  quality.append(qualChar);
  }
  GB2::MAlignmentRow row(name, sequence, h.h.second);
  row.setQuality(quality);
  
  if(BowtieContext::getSearchContext()->sortAlignment) {
	  int count = rowList.count();
	  bool indexFound = false;
	  for(int i=0;i<count;i++) {
		  if(rowList.at(i).getCoreStart() > row.getCoreStart()) {
			  rowList.insert(i, row);
			  indexFound = true;
			  break;
		  }
	  }
	  if(!indexFound) rowList.append(row);
  } else {
	  rowList.append(row);
  }
}

void MAlignmentHitSink::commitResultMA()
{
	for(int i=0;i<rowList.count();i++)
		resultMA.addRow(rowList.at(i));
}

