/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef LOCALTASKSTARTER_H
#define LOCALTASKSTARTER_H

#include <QtCore/QSet>
#include <QtCore/QDir>

#include <core_api/Task.h>
#include <distributed_computing/RemoteTaskError.h>

namespace GB2 {

class LocalTaskStarter : public Task
{
    Q_OBJECT
public:
    LocalTaskStarter(const QStringList &taskFileNames, const QString &tasksDirectory);

    virtual void run();
private:
    RemoteTaskError runLocalTask(const QVariant &data, QVariant *result);
    RemoteTaskError getTaskInfo(qint64 taskId, QVariant *result);
private:
    static const int UPDATE_TIME = 1000;
    QStringList taskFileNames;
    QSet<qint64> taskIds;

    QDir tasksDirectory;
};

} // namespace GB2

#endif // LOCALTASKSTARTER_H
