/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_SMITH_WATERMAN_TASK_FACTORY_H_
#define _U2_SMITH_WATERMAN_TASK_FACTORY_H_

#include "SmithWatermanSettings.h"
#include <U2Core/Task.h>


namespace U2 {

class SmithWatermanTaskFactory {
public:
    virtual Task* getTaskInstance(const SmithWatermanSettings& config,
                                  const QString& taskName) const = 0;
    virtual bool hasAdvancedSettings() const { return false; }
    virtual void execAdvancedDialog() {}
    virtual ~SmithWatermanTaskFactory() {}
};

} // namespace

#endif
