
typedef long NumberType;

__kernel void
        binarySearch_classic( __const __global NumberType  * sortedArray,
                                      __global NumberType  * findMeArray,
                             __const int  findMeArraySize,
                             __const   unsigned int globalLowerBound,
                             __const   unsigned int globalUpperBound,
                             __const   unsigned int numberOfIteration,
                             __const __global NumberType* preSaveBounds,
                             __const __global NumberType* c_preSaveValues,
                             __const int preSaveDepth,
                             __local NumberType* preSaveValues)
{
    const unsigned int tid = get_global_id(0);

    event_t event = 0;
    async_work_group_copy(preSaveValues, c_preSaveValues, preSaveDepth, event);

    unsigned int iterPos = tid * numberOfIteration;
    if (iterPos >= findMeArraySize) {
        return;
    }

    NumberType lowBound = 0, highBound = 0, findMe = 0,
        preLowBound = 0, preUpperBound = 0, preMid = 0,
        preCurValue = 0, mid = 0, curValue = 0;

    const NumberType firstPreMid = preSaveDepth / 2;
    const NumberType firstPreCurValue = preSaveValues[firstPreMid];

    for (int i = iterPos; i < iterPos + numberOfIteration; i++)
    {
        findMe = findMeArray[i];
        //TODO: optimize
        if (findMe > preSaveValues[preSaveDepth - 1]) {
            findMeArray[i] = -1;
            continue;
        }

        preLowBound = 0;
        preUpperBound = preSaveDepth;
        preMid = firstPreMid;
        preCurValue = firstPreCurValue;

//*****search in const memory
        for (int j = 0; preLowBound <= preUpperBound && preCurValue != findMe; j++){

            if (findMe > preCurValue) {
                preLowBound = preMid + 1;
            }
            else {
                preUpperBound = preMid - 1;
            }
            preMid = preLowBound + (preUpperBound - preLowBound) / 2;
            preCurValue = preSaveValues[preMid];
        }

        if ((preCurValue == findMe)) {
            findMeArray[i] = preSaveBounds[preMid];
            continue;
        } else {
            lowBound = preSaveBounds[preUpperBound];
            highBound = preSaveBounds[preLowBound];
        }
//*******

        mid = lowBound + (highBound - lowBound) / 2;
        curValue = sortedArray[mid];

        for (int j = 0; lowBound <= highBound && curValue != findMe; j++){

            if (findMe > curValue) {
                lowBound = mid + 1;
            }
            else {
                highBound = mid - 1;
            }
            mid = lowBound + (highBound - lowBound) / 2;
            curValue = sortedArray[mid];
        }
        if ((curValue == findMe)) {
            findMeArray[i] = mid;
        } else {
            findMeArray[i] = -1;
        }
    }
}
