/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_MSA_DISTANCE_ALGORITHM_REGISTRY_H_
#define _U2_MSA_DISTANCE_ALGORITHM_REGISTRY_H_

#include "MSADistanceAlgorithm.h"

#include <QtCore/QStringList>

namespace U2 {

class MSADistanceAlgorithm;

class U2ALGORITHM_EXPORT MSADistanceAlgorithmRegistry : public QObject {
    Q_OBJECT

public:
    MSADistanceAlgorithmRegistry(QObject* p = NULL);

    ~MSADistanceAlgorithmRegistry();

    MSADistanceAlgorithmFactory* getAlgorithmFactory(const QString& algoId);

    void addAlgorithm(MSADistanceAlgorithmFactory* algo);

    QStringList getAlgorithmIds() const ;

    QList<MSADistanceAlgorithmFactory*> getAlgorithmFactories() const {return algorithms.values();}

    QList<MSADistanceAlgorithmFactory*> getAlgorithmFactories(DistanceAlgorithmFlags flags) const;

private:
    QMap<QString , MSADistanceAlgorithmFactory*> algorithms;
};

}//namespace

#endif
