/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/


#include <U2Core/AppContext.h>
#include <U2Core/CMDLineRegistry.h>
#include <U2Core/CMDLineHelpProvider.h>

#include "CMDLineCoreOptions.h"

namespace U2 {

const QString CMDLineCoreOptions::INI_FILE      = "ini-file";
const QString CMDLineCoreOptions::SUITE_URLS    = "test-suite";
const QString CMDLineCoreOptions::TEST_REPORT   = "test-report";
const QString CMDLineCoreOptions::TEST_THREADS  = "test-threads";
const QString CMDLineCoreOptions::STAY_ALIVE    = "ugene-stay-alive";
const QString CMDLineCoreOptions::HELP          = "help";
const QString CMDLineCoreOptions::TRANSLATION   = "transl";

void CMDLineCoreOptions::initHelp() {
    CMDLineRegistry * cmdLineRegistry = AppContext::getCMDLineRegistry();
    assert( NULL != cmdLineRegistry );
    
    CMDLineHelpProvider * helpSection = new CMDLineHelpProvider( HELP, tr( "show help information" ) );
    
    CMDLineHelpProvider * stayAliveSection = new CMDLineHelpProvider( STAY_ALIVE,
        tr( "ugene will continue executing after finishing given tasks" ) );
    
    CMDLineHelpProvider * suiteUrlSectionArguments = new CMDLineHelpProvider( SUITE_URLS, "<test-suite> [suite2 ...]" );
    CMDLineHelpProvider * suiteUrlSection = new CMDLineHelpProvider( SUITE_URLS, tr( "load test suites and run them" ) );

    CMDLineHelpProvider *testReportArgument = new CMDLineHelpProvider( TEST_REPORT,"<test-report-directory>");
    CMDLineHelpProvider *testReport = new CMDLineHelpProvider(TEST_REPORT, tr("set directory for test report"));

    CMDLineHelpProvider *testRunnerThreadsArgument = new CMDLineHelpProvider(TEST_THREADS, "<number-of-threads>");
    CMDLineHelpProvider *testRunnerThreads = new CMDLineHelpProvider(TEST_THREADS,
        tr("set number of threads in test runner that can run at the same time"));
    
    CMDLineHelpProvider * loadSettingsFileSectionArguments = new CMDLineHelpProvider( INI_FILE, "<settings-file>" );
    CMDLineHelpProvider * loadSettingsFileSection = new CMDLineHelpProvider( INI_FILE, tr( "load configuration from the specified file" ) );
    
    CMDLineHelpProvider * translSectionArguments = new CMDLineHelpProvider(TRANSLATION, "<language-code>");
    CMDLineHelpProvider * translSection = new CMDLineHelpProvider(TRANSLATION, "load translations of specified language. Language is specified as a two-letter ISO 639 language code");
    
    cmdLineRegistry->registerCMDLineHelpProvider( helpSection );
    cmdLineRegistry->registerCMDLineHelpProvider( stayAliveSection );
    cmdLineRegistry->registerCMDLineHelpProvider( suiteUrlSectionArguments );
    cmdLineRegistry->registerCMDLineHelpProvider( suiteUrlSection );
    cmdLineRegistry->registerCMDLineHelpProvider( loadSettingsFileSectionArguments );
    cmdLineRegistry->registerCMDLineHelpProvider( loadSettingsFileSection );
    cmdLineRegistry->registerCMDLineHelpProvider( testReportArgument );
    cmdLineRegistry->registerCMDLineHelpProvider( testReport );
    cmdLineRegistry->registerCMDLineHelpProvider( testRunnerThreadsArgument );
    cmdLineRegistry->registerCMDLineHelpProvider( testRunnerThreads );
    cmdLineRegistry->registerCMDLineHelpProvider( translSectionArguments );
    cmdLineRegistry->registerCMDLineHelpProvider( translSection );
}

} // U2
