/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_GOBJECT_TYPES_H_
#define _U2_GOBJECT_TYPES_H_

#include <U2Core/global.h>
#include <QtGui/QIcon>

namespace U2 {

class U2CORE_EXPORT GObjectTypeInfo {
public:
    GObjectTypeInfo(){}
    GObjectTypeInfo(const GObjectType& _type, const QString& _name, const QString& _pluralName, const QString& treeSign, const QString iconURL);

    GObjectType type;
    QString     name;
    QString     pluralName;
    QString     treeSign;
    QString     iconURL;
    QIcon       icon;
};

class U2CORE_EXPORT GObjectTypes {
public:
    static const GObjectType UNKNOWN;
    static const GObjectType UNLOADED;
    static const GObjectType TEXT;
    static const GObjectType SEQUENCE;
    static const GObjectType ANNOTATION_TABLE;
    static const GObjectType CHROMATOGRAM;
    static const GObjectType MULTIPLE_ALIGNMENT;
    static const GObjectType PHYLOGENETIC_TREE;
    static const GObjectType BIOSTRUCTURE_3D;
    static const GObjectType UINDEX;
    
    static GObjectType registerTypeInfo(const GObjectTypeInfo& ti);

    //Returns reference to the type by type. 
    //WARN: Caching return value by reference is not safe -> it can be relocated if new type is registered
    static const GObjectTypeInfo& getTypeInfo(const QString& t);
    
    static void initTypeTranslations(); //must be called only once after all translations are loaded
    static void initTypeIcons();

};

}//namespace


#endif
