/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include <U2Core/AppContext.h>
#include "ProjectModel.h"

namespace U2 {

void Project::setupToEngine(QScriptEngine *engine)
{
    Document::setupToEngine(engine);
    qScriptRegisterMetaType(engine, toScriptValue, fromScriptValue);
    qScriptRegisterSequenceMetaType<QList<Document*> >(engine);
};
QScriptValue Project::toScriptValue(QScriptEngine *engine, Project* const &in)
{ 
    return engine->newQObject(in); 
}

void Project::fromScriptValue(const QScriptValue &object, Project* &out) 
{
    out = qobject_cast<Project*>(object.toQObject()); 
}

}//namespace
