/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "LRegionsSelection.h"

namespace U2 {

static QList<LRegion> emptyLRegions;
void LRegionsSelection::clear() {
    QList<LRegion> tmpRemoved = regions;
    regions.clear();
    if (!tmpRemoved.isEmpty()) {
        emit si_selectionChanged(this, emptyLRegions, tmpRemoved);
    }
}

void LRegionsSelection::addRegion(const LRegion& r) {
    assert(r.len > 0);
    if (regions.contains(r)) {
        return;
    }
    regions.append(r);
    QList<LRegion> tmpAdded; tmpAdded.append(r);
    emit si_selectionChanged(this, tmpAdded, emptyLRegions);
}

void LRegionsSelection::removeRegion(const LRegion& r) {
    int n = regions.removeAll(r);
    if (n == 0) {
        return;
    }
    QList<LRegion> tmpRemoved; tmpRemoved.append(r);
    emit si_selectionChanged(this, emptyLRegions, tmpRemoved);
}

void LRegionsSelection::setSelectedRegions(const QList<LRegion>& newSelection) {
    QList<LRegion> tmpRemoved = regions;
    regions = newSelection;
    emit si_selectionChanged(this, newSelection, tmpRemoved);    
}

} //namespace
